/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.tag;

import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.RenderService;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.renderer.model.RegionWidgetWrapper;
import org.apache.rave.portal.web.tag.AbstractContextAwareSingletonBeanDependentTag;

public class RegionWidgetTag
extends AbstractContextAwareSingletonBeanDependentTag<RenderService> {
    private RegionWidget regionWidget;
    private Widget widget;
    private static final String REGISTER_DISABLED_WIDGET_KEY = "disabledRegisterWidget";
    private static final String DISABLED_SCRIPT_BLOCK = "<script>require(['rave'], function(rave){rave.registerWidget('%1$s', {type: 'DISABLED', regionWidgetId: '%2$s', disabledMessage: '%3$s', collapsed: %4$s, widgetId: '%5$s'})});</script>";

    public RegionWidgetTag() {
        super(RenderService.class);
    }

    public RegionWidget getRegionWidget() {
        return this.regionWidget;
    }

    public void setRegionWidget(RegionWidget regionWidget) {
        this.regionWidget = regionWidget;
    }

    public Widget getWidget() {
        return this.widget;
    }

    public void setWidget(Widget widget) {
        this.widget = widget;
    }

    public int doStartTag() throws JspException {
        if (this.regionWidget == null) {
            throw new JspException("RegionWidget not set: " + this.regionWidget);
        }
        if (this.widget != null && ((RenderService)this.getBean()).getSupportedWidgetTypes().contains(this.widget.getType())) {
            if (this.widget.isDisableRendering()) {
                ScriptManager scriptManager = this.getBeanFromContext(ScriptManager.class);
                String widgetScript = String.format(DISABLED_SCRIPT_BLOCK, this.regionWidget.getRegion().getId(), this.regionWidget.getId(), StringEscapeUtils.escapeEcmaScript((String)this.widget.getDisableRenderingMessage()), this.regionWidget.isCollapsed(), this.widget.getId());
                String key = "disabledRegisterWidget-" + this.widget.getId();
                scriptManager.registerScriptBlock(key, widgetScript, ScriptLocation.AFTER_RAVE, RenderScope.CURRENT_REQUEST, this.getContext());
            } else {
                this.writeString(((RenderService)this.getBean()).render(new RegionWidgetWrapper(this.widget, this.regionWidget), this.getContext()));
            }
        } else {
            throw new JspException("Unsupported regionWidget type: " + this.regionWidget);
        }
        this.regionWidget = null;
        this.widget = null;
        return 1;
    }
}

