/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.validator;

import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.User;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.validator.NewAccountValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class NewPasswordValidator
extends NewAccountValidator {
    private static Logger log = LoggerFactory.getLogger(NewPasswordValidator.class);

    @Autowired
    public NewPasswordValidator(UserService userService) {
        super(userService);
    }

    @Override
    public void validate(Object target, Errors errors) {
        log.debug("Password validator called");
        User newUser = (User)target;
        String email = newUser.getEmail();
        this.validateEmail(errors, email);
        if (errors.hasErrors()) {
            return;
        }
        User user = this.getUserService().getUserByEmail(email);
        if (user == null) {
            errors.rejectValue("email", "account.invalid");
            log.info("Couldn't find user for email {}", (Object)email);
            return;
        }
        if (user.isLocked() || user.isExpired() || !user.isEnabled()) {
            errors.rejectValue("email", "account.invalid");
        }
    }

    private void validateEmail(Errors errors, String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            errors.rejectValue("email", "email.required");
        } else if (this.isInvalidEmailAddress(email)) {
            errors.rejectValue("email", "email.invalid");
        } else if (!this.isExistingEmailAddress(email)) {
            errors.rejectValue("email", "email.doesnot.exist");
        }
    }
}

