/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.shindig.common.util.Check;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CheckTest {
    static final String STATIC_MESSAGE = "message";
    static final String MESSAGE_FORMAT = "the %s message";
    static final int MESSAGE_VALUE = 42;
    static final String FORMATTED_MESSAGE = "the 42 message";
    static final String ARG_NAME = "arg";

    public static Test suite() {
        return new JUnit4TestAdapter(CheckTest.class);
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void is_Message_ThrowsWhenFalse() {
        Check.is((boolean)false, (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void is_MessageArgs_ThrowsWhenFalse() {
        Check.is((boolean)false, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void is_Message_ReturnsWhenTrue() {
        try {
            Check.is((boolean)true, (String)STATIC_MESSAGE);
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void is_MessageArgs_ReturnsWhenTrue() {
        try {
            Check.is((boolean)true, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void eq_Message_ThrowsWhenNotEqual() {
        Check.eq((Object)2, (Object)3, (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void eq_MessageArgs_ThrowsWhenNotEqual() {
        Check.eq((Object)"bob", (Object)"chuck", (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void eq_Message_ReturnsWhenEqual() {
        try {
            Check.eq((Object)"frank", (Object)"franko".substring(0, 5), (String)STATIC_MESSAGE);
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void eq_MessageArgs_ReturnsWhenEqual() {
        try {
            Check.eq((Object)Character.valueOf('c'), (Object)Character.valueOf('c'), (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void that_ThrowsWhenFalse() {
        Check.that((Object)"bob", (Matcher)Matchers.equalTo((Object)"frank"));
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void that_Message_ThrowsWhenFalse() {
        Check.that((Object)"bob", (Matcher)Matchers.equalTo((Object)"frank"), (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void that_MessageArgs_ThrowsWhenFalse() {
        Check.that((Object)"bob", (Matcher)Matchers.equalTo((Object)"frank"), (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void that_ReturnsWhenTrue() {
        try {
            Check.that((Object)23, (Matcher)Matchers.equalTo((Object)23), (String)STATIC_MESSAGE);
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void that_Message_ReturnsWhenTrue() {
        try {
            Check.that((Object)23, (Matcher)Matchers.equalTo((Object)23), (String)STATIC_MESSAGE);
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void that_MessageArgs_ReturnsWhenTrue() {
        try {
            Check.that((Object)23, (Matcher)Matchers.equalTo((Object)23), (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalStateException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notNull_ThrowsWhenNotNull() {
        Check.notNull(null);
    }

    @org.junit.Test
    public void notNull_ReturnsWhenNull() {
        try {
            Check.notNull((Object)24);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notNull_Message_ThrowsWhenNotNull() {
        Check.notNull(null, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void notNull_Message_ReturnsWhenNull() {
        try {
            Check.notNull((Object)"bob", (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notNull_MessageArgs_ThrowsWhenNotNull() {
        Check.notNull(null, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void notNull_MessageArgs_ReturnsWhenNull() {
        try {
            Check.notNull((Object)"bob", (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyString_ThrowsWhenNull() {
        String string = null;
        Check.notEmpty(string);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyString_ThrowsWhenEmpty() {
        String string = "";
        Check.notEmpty((String)string, (String)ARG_NAME);
    }

    @org.junit.Test
    public void notEmptyString_ReturnsWhenNotEmpty() {
        try {
            String string = "full";
            Check.notEmpty((String)string, (String)ARG_NAME);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyString_Message_ThrowsWhenNull() {
        String string = null;
        Check.notEmpty(string, (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyString_Message_ThrowsWhenEmpty() {
        String string = "";
        Check.notEmpty((String)string, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void notEmptyString_Message_ReturnsWhenNotEmpty() {
        try {
            String string = "full";
            Check.notEmpty((String)string, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyString_MessageArgs_ThrowsWhenNull() {
        String string = null;
        Check.notEmpty(string, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyString_MessageArgs_ThrowsWhenEmpty() {
        String string = "";
        Check.notEmpty((String)string, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void notEmptyString_MessageArgs_ReturnsWhenNotEmpty() {
        try {
            String string = "full";
            Check.notEmpty((String)string, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyObjectArray_ThrowsWhenNull() {
        Object[] array = null;
        Check.notEmpty(array);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyObjectArray_ThrowsWhenEmpty() {
        Object[] array = new Object[]{};
        Check.notEmpty((Object[])array);
    }

    @org.junit.Test
    public void notEmptyObjectArray_ReturnsWhenNotEmpty() {
        try {
            Object[] array = new Object[1];
            Check.notEmpty((Object[])array);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyObjectArray_Message_ThrowsWhenNull() {
        Object[] array = null;
        Check.notEmpty(array, (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyObjectArray_Message_ThrowsWhenEmpty() {
        Object[] array = new Object[]{};
        Check.notEmpty((Object[])array, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void notEmptyObjectArray_Message_ReturnsWhenNotEmpty() {
        try {
            Object[] array = new Object[1];
            Check.notEmpty((Object[])array, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyObjectArray_MessageArgs_ThrowsWhenNull() {
        Object[] array = null;
        Check.notEmpty(array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyObjectArray_MessageArgs_ThrowsWhenEmpty() {
        Object[] array = new Object[]{};
        Check.notEmpty((Object[])array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void notEmptyObjectArray_MessageArgs_ReturnsWhenNotEmpty() {
        try {
            Object[] array = new Object[1];
            Check.notEmpty((Object[])array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyCollection_ThrowsWhenNull() {
        Collection collection = null;
        Check.notEmpty(collection);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyCollection_ThrowsWhenEmpty() {
        ArrayList collection = Lists.newArrayList();
        Check.notEmpty((Collection)collection);
    }

    @org.junit.Test
    public void notEmptyCollection_ReturnsWhenNotEmpty() {
        try {
            ArrayList collection = Lists.newArrayList();
            collection.add(null);
            Check.notEmpty((Collection)collection);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyCollection_Message_ThrowsWhenNull() {
        Collection collection = null;
        Check.notEmpty(collection, (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyCollection_Message_ThrowsWhenEmpty() {
        ArrayList collection = Lists.newArrayList();
        Check.notEmpty((Collection)collection, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void notEmptyCollection_Message_ReturnsWhenNotEmpty() {
        try {
            ArrayList collection = Lists.newArrayList();
            collection.add(null);
            Check.notEmpty((Collection)collection, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyCollection_MessageArgs_ThrowsWhenNull() {
        Collection collection = null;
        Check.notEmpty(collection, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyCollection_MessageArgs_ThrowsWhenEmpty() {
        ArrayList collection = Lists.newArrayList();
        Check.notEmpty((Collection)collection, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void notEmptyCollection_MessageArgs_ReturnsWhenNotEmpty() {
        try {
            ArrayList collection = Lists.newArrayList();
            collection.add(null);
            Check.notEmpty((Collection)collection, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyMap_ThrowsWhenNull() {
        Map map = null;
        Check.notEmpty(map);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyMap_ThrowsWhenEmpty() {
        HashMap map = Maps.newHashMap();
        Check.notEmpty((Map)map);
    }

    @org.junit.Test
    public void notEmptyMap_ReturnsWhenNotEmpty() {
        try {
            HashMap map = Maps.newHashMap();
            map.put(null, null);
            Check.notEmpty((Map)map);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyMap_Message_ThrowsWhenNull() {
        Map map = null;
        Check.notEmpty(map, (String)STATIC_MESSAGE);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyMap_Message_ThrowsWhenEmpty() {
        HashMap map = Maps.newHashMap();
        Check.notEmpty((Map)map, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void notEmptyMap_Message_ReturnsWhenNotEmpty() {
        try {
            HashMap map = Maps.newHashMap();
            map.put(null, null);
            Check.notEmpty((Map)map, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyMap_MessageArgs_ThrowsWhenNull() {
        Map map = null;
        Check.notEmpty(map, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void notEmptyMap_MessageArgs_ThrowsWhenEmpty() {
        HashMap map = Maps.newHashMap();
        Check.notEmpty((Map)map, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void notEmptyMap_MessageArgs_ReturnsWhenNotEmpty() {
        try {
            HashMap map = Maps.newHashMap();
            map.put(null, null);
            Check.notEmpty((Map)map, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_ReturnsWhenNull() {
        try {
            Object[] array = null;
            Check.noNulls(array);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_ReturnsWhenEmpty() {
        try {
            Object[] array = new Object[]{};
            Check.noNulls((Object[])array);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_ReturnsWhenNotEmptyWithNoNulls() {
        try {
            Object[] array = new Object[]{"bob", "frank"};
            Check.noNulls((Object[])array);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void noNullsObjectArray_ThrowsWhenHasANull() {
        Object[] array = new Object[]{"bob", null};
        Check.noNulls((Object[])array);
    }

    @org.junit.Test
    public void noNullsObjectArray_Message_ReturnsWhenNull() {
        try {
            Object[] array = null;
            Check.noNulls(array, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_Message_ReturnsWhenEmpty() {
        try {
            Object[] array = new Object[]{};
            Check.noNulls((Object[])array, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_Message_ReturnsWhenNotEmptyWithNoNulls() {
        try {
            Object[] array = new Object[]{"bob", "frank"};
            Check.noNulls((Object[])array, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void noNullsObjectArray_Message_ThrowsWhenHasANull() {
        Object[] array = new Object[]{"bob", null};
        Check.noNulls((Object[])array, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void noNullsObjectArray_MessageArgs_ReturnsWhenNull() {
        try {
            Object[] array = null;
            Check.noNulls(array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_MessageArgs_ReturnsWhenEmpty() {
        try {
            Object[] array = new Object[]{};
            Check.noNulls((Object[])array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsObjectArray_MessageArgs_ReturnsWhenNotEmptyWithNoNulls() {
        try {
            Object[] array = new Object[]{"bob", "frank"};
            Check.noNulls((Object[])array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void noNullsObjectArray_MessageArgs_ThrowsWhenHasANull() {
        Object[] array = new Object[]{"bob", null};
        Check.noNulls((Object[])array, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }

    @org.junit.Test
    public void noNullsIterable_ReturnsWhenNull() {
        try {
            Iterable iterable = null;
            Check.noNulls(iterable);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsList_ReturnsWhenEmpty() {
        try {
            ArrayList iterable = Lists.newArrayList();
            Check.noNulls((Iterable)iterable);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsList_ReturnsWhenNotEmptyWithNoNulls() {
        try {
            ArrayList iterable = Lists.newArrayList();
            iterable.add("bob");
            Check.noNulls((Iterable)iterable);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void noNullsList_ThrowsWhenHasANull() {
        ArrayList iterable = Lists.newArrayList();
        iterable.add("bob");
        iterable.add(null);
        Check.noNulls((Iterable)iterable);
    }

    @org.junit.Test
    public void noNullsIterable_Message_ReturnsWhenNull() {
        try {
            Iterable iterable = null;
            Check.noNulls(iterable, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsList_Message_ReturnsWhenEmpty() {
        try {
            ArrayList iterable = Lists.newArrayList();
            Check.noNulls((Iterable)iterable, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsList_Message_ReturnsWhenNotEmptyWithNoNulls() {
        try {
            ArrayList iterable = Lists.newArrayList();
            iterable.add("bob");
            Check.noNulls((Iterable)iterable, (String)STATIC_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void noNullsList_Message_ThrowsWhenHasANull() {
        ArrayList iterable = Lists.newArrayList();
        iterable.add("bob");
        iterable.add(null);
        Check.noNulls((Iterable)iterable, (String)STATIC_MESSAGE);
    }

    @org.junit.Test
    public void noNullsIterable_MessageArgs_ReturnsWhenNull() {
        try {
            Iterable iterable = null;
            Check.noNulls(iterable, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsList_MessageArgs_ReturnsWhenEmpty() {
        try {
            ArrayList iterable = Lists.newArrayList();
            Check.noNulls((Iterable)iterable, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test
    public void noNullsList_MessageArgs_ReturnsWhenNotEmptyWithNoNulls() {
        try {
            ArrayList iterable = Lists.newArrayList();
            iterable.add("bob");
            Check.noNulls((Iterable)iterable, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void noNullsList_MessageArgs_ThrowsWhenHasANull() {
        ArrayList iterable = Lists.newArrayList();
        iterable.add("bob");
        iterable.add(null);
        Check.noNulls((Iterable)iterable, (String)MESSAGE_FORMAT, (Object[])new Object[]{42});
    }
}

