/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache;

import junit.framework.TestCase;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.LruCache;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftExpiringCacheTest
extends TestCase {
    private FakeTimeSource timeSource;
    private Cache<String, String> cache;

    public void setUp() throws Exception {
        this.timeSource = new FakeTimeSource(0L);
        this.cache = new LruCache(5);
    }

    private SoftExpiringCache<String, String> makeSoftExpiringCache() {
        SoftExpiringCache expiringCache = new SoftExpiringCache(this.cache);
        expiringCache.setTimeSource((TimeSource)this.timeSource);
        return expiringCache;
    }

    public void testGeneralCacheExpiration() {
        SoftExpiringCache<String, String> expiringCache = this.makeSoftExpiringCache();
        String key = "key1";
        String val = "val1";
        expiringCache.addElement((Object)key, (Object)val, 240000L);
        SoftExpiringCacheTest.assertEquals((String)val, (String)((String)expiringCache.getElement((Object)key).obj));
        SoftExpiringCacheTest.assertFalse((boolean)expiringCache.getElement((Object)key).isExpired);
        this.timeSource.setCurrentTimeMillis(300000L);
        SoftExpiringCacheTest.assertEquals((String)val, (String)((String)expiringCache.getElement((Object)key).obj));
        SoftExpiringCacheTest.assertTrue((boolean)expiringCache.getElement((Object)key).isExpired);
    }

    public void testMissingValue() {
        SoftExpiringCache<String, String> expiringCache = this.makeSoftExpiringCache();
        SoftExpiringCacheTest.assertNull((Object)expiringCache.getElement((Object)"not set"));
    }
}

