/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.shindig.auth.BasicSecurityTokenCodec;
import org.apache.shindig.config.BasicContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicSecurityTokenCodecTest {
    private BasicSecurityTokenCodec codec;
    private ContainerConfig config;

    @Before
    public void setUp() throws Exception {
        this.config = new BasicContainerConfig();
        this.codec = new BasicSecurityTokenCodec(this.config);
    }

    @Test
    public void testGetTokenTimeToLive() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap container = builder.put((Object)"gadgets.container", (Object)ImmutableList.of((Object)"default", (Object)"tokenTest")).put((Object)"gadgets.securityTokenTTL", (Object)300).build();
        this.config.newTransaction().addContainer((Map)container).commit();
        Assert.assertEquals((String)"Token TTL matches what is set in the container config", (long)300L, (long)this.codec.getTokenTimeToLive("tokenTest"));
        Assert.assertEquals((String)"Token TTL matches the default TTL", (long)3600L, (long)this.codec.getTokenTimeToLive());
    }
}

