/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityTokenCodec;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.HMACType;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.config.BasicContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobCrypterSecurityTokenCodecTest {
    private BlobCrypterSecurityTokenCodec codec;
    private FakeTimeSource timeSource;
    private ContainerConfig config;

    @Before
    public void setUp() throws Exception {
        this.config = new BasicContainerConfig();
        this.config.newTransaction().addContainer(this.makeContainer("default")).addContainer(this.makeContainer("container")).addContainer(this.makeContainer("example")).commit();
        this.codec = new BlobCrypterSecurityTokenCodec(this.config);
        this.timeSource = new FakeTimeSource();
    }

    protected Map<String, Object> makeContainer(String container) {
        return ImmutableMap.of((Object)"gadgets.container", (Object)ImmutableList.of((Object)container), (Object)"gadgets.securityTokenKey", (Object)this.getContainerKey(container), (Object)"gadgets.signedFetchDomain", (Object)(container + ".com"));
    }

    protected String getContainerKey(String container) {
        return "KEY FOR CONTAINER " + container;
    }

    protected BlobCrypter getBlobCrypter(String key) {
        BasicBlobCrypter c = new BasicBlobCrypter(key, HMACType.HMACSHA1);
        c.timeSource = this.timeSource;
        return c;
    }

    @Test
    public void testCreateToken() throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "http://www.example.com/gadget.xml");
        values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), Long.toString(12345L, 10));
        values.put(AbstractSecurityToken.Keys.OWNER.getKey(), "owner");
        values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "viewer");
        values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken("container", null, null, values);
        String encrypted = t.getContainer() + ":" + this.getBlobCrypter(this.getContainerKey("container")).wrap(t.toMap());
        SecurityToken t2 = this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
        Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppId());
        Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppUrl());
        Assert.assertEquals((Object)"container.com", (Object)t2.getDomain());
        Assert.assertEquals((long)12345L, (long)t2.getModuleId());
        Assert.assertEquals((Object)"owner", (Object)t2.getOwnerId());
        Assert.assertEquals((Object)"viewer", (Object)t2.getViewerId());
        Assert.assertEquals((Object)"trusted", (Object)t2.getTrustedJson());
    }

    @Test
    public void testUnknownContainer() throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "http://www.example.com/gadget.xml");
        values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), Long.toString(12345L, 10));
        values.put(AbstractSecurityToken.Keys.OWNER.getKey(), "owner");
        values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "viewer");
        values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken("container", null, null, values);
        String encrypted = t.getContainer() + ":" + this.getBlobCrypter(this.getContainerKey("container")).wrap(t.toMap());
        encrypted = encrypted.replace("container:", "other:");
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"should have reported that container was unknown");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Unknown container"));
        }
    }

    @Test
    public void testWrongContainer() throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "http://www.example.com/gadget.xml");
        values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), Long.toString(12345L, 10));
        values.put(AbstractSecurityToken.Keys.OWNER.getKey(), "owner");
        values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "viewer");
        values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken("container", null, null, values);
        String encrypted = t.getContainer() + ":" + this.getBlobCrypter(this.getContainerKey("container")).wrap(t.toMap());
        encrypted = encrypted.replace("container:", "example:");
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"should have tried to decrypt with wrong key");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid token signature"));
        }
    }

    @Test
    public void testExpired() throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "http://www.example.com/gadget.xml");
        values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), Long.toString(12345L, 10));
        values.put(AbstractSecurityToken.Keys.OWNER.getKey(), "owner");
        values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "viewer");
        values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
        BlobCrypterSecurityToken token = new BlobCrypterSecurityToken("container", null, null, values);
        token.setTimeSource((TimeSource)this.timeSource);
        this.timeSource.incrementSeconds(-1 * (this.codec.getTokenTimeToLive("container") + 181));
        String encrypted = this.codec.encodeToken((SecurityToken)token);
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"should have expired");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Blob expired"));
        }
    }

    @Test
    public void testMalformed() throws Exception {
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)"foo"));
            Assert.fail((String)"should have tried to decrypt with wrong key");
        }
        catch (SecurityTokenException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid security token foo"));
        }
    }

    @Test
    public void testAnonymous() throws Exception {
        SecurityToken t = this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)"   "));
        Assert.assertTrue((boolean)t.isAnonymous());
        ImmutableMap empty = ImmutableMap.of();
        t = this.codec.createToken((Map)empty);
        Assert.assertTrue((boolean)t.isAnonymous());
    }

    @Test
    public void testChangingContainers() throws Exception {
        String newContainer = "newcontainer";
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "http://www.example.com/gadget.xml");
        values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), Long.toString(12345L, 10));
        values.put(AbstractSecurityToken.Keys.OWNER.getKey(), "owner");
        values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "viewer");
        values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(newContainer, null, null, values);
        String encrypted = t.getContainer() + ":" + this.getBlobCrypter(this.getContainerKey(newContainer)).wrap(t.toMap());
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"Should have thrown a SecurityTokenException");
        }
        catch (SecurityTokenException e) {
            // empty catch block
        }
        this.config.newTransaction().addContainer(this.makeContainer(newContainer)).commit();
        this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
        this.config.newTransaction().removeContainer(newContainer).commit();
        try {
            this.codec.createToken((Map)ImmutableMap.of((Object)"token", (Object)encrypted));
            Assert.fail((String)"Should have thrown a SecurityTokenException");
        }
        catch (SecurityTokenException e) {
            // empty catch block
        }
    }

    @Test
    public void testGetTokenTimeToLive() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap container = builder.putAll(this.makeContainer("tokenTest")).put((Object)"gadgets.securityTokenTTL", (Object)300).build();
        this.config.newTransaction().addContainer((Map)container).commit();
        Assert.assertEquals((String)"Token TTL matches what is set in the container config", (long)300L, (long)this.codec.getTokenTimeToLive("tokenTest"));
        Assert.assertEquals((String)"Token TTL matches the default TTL", (long)3600L, (long)this.codec.getTokenTimeToLive());
    }
}

