/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.HMACType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobCrypterSecurityTokenTest {
    private static final String CONTAINER = "container";
    private static final String DOMAIN = "example.com";
    private FakeTimeSource timeSource = new FakeTimeSource();
    private BasicBlobCrypter crypter;
    private BasicBlobCrypter crypter256;
    private BasicBlobCrypter crypter384;
    private BasicBlobCrypter crypter512;
    private List<BasicBlobCrypter> crypters = new ArrayList<BasicBlobCrypter>();

    @Before
    public void setUp() {
        this.crypter = new BasicBlobCrypter(Crypto.getRandomBytes((int)20), HMACType.HMACSHA1);
        this.crypter256 = new BasicBlobCrypter(Crypto.getRandomBytes((int)20), HMACType.HMACSHA256);
        this.crypter384 = new BasicBlobCrypter(Crypto.getRandomBytes((int)20), HMACType.HMACSHA384);
        this.crypter512 = new BasicBlobCrypter(Crypto.getRandomBytes((int)20), HMACType.HMACSHA512);
        this.crypters.add(this.crypter);
        this.crypters.add(this.crypter256);
        this.crypters.add(this.crypter384);
        this.crypters.add(this.crypter512);
        this.crypter.timeSource = this.timeSource;
    }

    @Test
    public void testNullValues() throws Exception {
        for (BasicBlobCrypter crypter : this.crypters) {
            BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(CONTAINER, DOMAIN, null, null);
            String token = t.getContainer() + ":" + crypter.wrap(t.toMap());
            Assert.assertTrue((String)("should start with container: " + token), (boolean)token.startsWith("container:"));
            String[] fields = StringUtils.split((String)token, (char)':');
            BlobCrypterSecurityToken t2 = new BlobCrypterSecurityToken(CONTAINER, DOMAIN, null, crypter.unwrap(fields[1]));
            Assert.assertNull((String)t2.getAppId(), (Object)t2.getAppId());
            Assert.assertNull((String)t2.getAppUrl(), (Object)t2.getAppUrl());
            Assert.assertEquals((Object)DOMAIN, (Object)t2.getDomain());
            Assert.assertEquals((long)0L, (long)t2.getModuleId());
            Assert.assertNull((String)t2.getOwnerId(), (Object)t2.getOwnerId());
            Assert.assertNull((String)t2.getViewerId(), (Object)t2.getViewerId());
            Assert.assertNull((String)t2.getTrustedJson(), (Object)t2.getTrustedJson());
            Assert.assertNull((String)t2.getUpdatedToken(), (Object)t2.getUpdatedToken());
            Assert.assertEquals((Object)CONTAINER, (Object)t2.getContainer());
            Assert.assertNull((String)t2.getActiveUrl(), (Object)t2.getActiveUrl());
        }
    }

    @Test
    public void testRealValues() throws Exception {
        for (BasicBlobCrypter crypter : this.crypters) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), "http://www.example.com/gadget.xml");
            values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), Long.toString(12345L, 10));
            values.put(AbstractSecurityToken.Keys.OWNER.getKey(), "owner");
            values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), "viewer");
            values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "trusted");
            BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(CONTAINER, DOMAIN, null, values);
            String token = t.getContainer() + ":" + crypter.wrap(t.toMap());
            Assert.assertTrue((String)("should start with container: " + token), (boolean)token.startsWith("container:"));
            String[] fields = StringUtils.split((String)token, (char)':');
            BlobCrypterSecurityToken t2 = new BlobCrypterSecurityToken(CONTAINER, DOMAIN, "active", crypter.unwrap(fields[1]));
            Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppId());
            Assert.assertEquals((Object)"http://www.example.com/gadget.xml", (Object)t2.getAppUrl());
            Assert.assertEquals((Object)DOMAIN, (Object)t2.getDomain());
            Assert.assertEquals((long)12345L, (long)t2.getModuleId());
            Assert.assertEquals((Object)"owner", (Object)t2.getOwnerId());
            Assert.assertEquals((Object)"viewer", (Object)t2.getViewerId());
            Assert.assertEquals((Object)"trusted", (Object)t2.getTrustedJson());
            Assert.assertEquals((Object)CONTAINER, (Object)t2.getContainer());
            Assert.assertEquals((Object)"active", (Object)t2.getActiveUrl());
        }
    }
}

