/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.BasicSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.auth.UrlParameterAuthenticationHandler;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UrlParameterAuthenticationHandlerTest {
    SecurityToken expectedToken;
    UrlParameterAuthenticationHandler authHandler;
    SecurityTokenCodec codec;
    HttpServletRequest req;

    @Before
    public void setup() throws Exception {
        this.expectedToken = new BasicSecurityToken("owner", "viewer", "app", "domain", "appUrl", "0", "container", "activeUrl", Long.valueOf(1000L));
        this.codec = new SecurityTokenCodec(){

            public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
                return tokenParameters == null ? null : ("1234".equals(tokenParameters.get("token")) ? UrlParameterAuthenticationHandlerTest.this.expectedToken : null);
            }

            public String encodeToken(SecurityToken token) throws SecurityTokenException {
                return null;
            }

            public int getTokenTimeToLive() {
                return 0;
            }

            public int getTokenTimeToLive(String container) {
                return 0;
            }
        };
        this.authHandler = new UrlParameterAuthenticationHandler(this.codec, Boolean.valueOf(true));
    }

    @Test
    public void testGetSecurityTokenFromRequest() throws Exception {
        Assert.assertEquals((Object)this.authHandler.getName(), (Object)AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name());
    }

    @Test
    public void testInvalidRequests() throws Exception {
        this.req = new FakeHttpServletRequest();
        Assert.assertNull((Object)this.authHandler.getSecurityTokenFromRequest(this.req));
        this.req = new FakeHttpServletRequest().setHeader("Authorization", "Token token=\"1234\"");
        Assert.assertNull((Object)this.authHandler.getSecurityTokenFromRequest(this.req));
        this.req = new FakeHttpServletRequest().setHeader("Authorization", "OAuth 1234");
        Assert.assertNull((Object)this.authHandler.getSecurityTokenFromRequest(this.req));
    }

    @Test
    public void testSecurityToken() throws Exception {
        this.req = new FakeHttpServletRequest("http://example.org/rpc?st=1234");
        Assert.assertEquals((Object)this.expectedToken, (Object)this.authHandler.getSecurityTokenFromRequest(this.req));
    }

    @Test
    public void testOAuth1() throws Exception {
        this.req = new FakeHttpServletRequest().setHeader("Authorization", "OAuth oauth_signature_method=\"RSA-SHA1\"");
        SecurityToken token = this.authHandler.getSecurityTokenFromRequest(this.req);
        Assert.assertNull((Object)token);
    }

    @Test
    public void testOAuth2Header() throws Exception {
        this.req = new FakeHttpServletRequest("https://www.example.org/").setHeader("Authorization", "OAuth2  1234");
        Assert.assertEquals((Object)this.expectedToken, (Object)this.authHandler.getSecurityTokenFromRequest(this.req));
        this.req = new FakeHttpServletRequest("https://www.example.org/").setHeader("Authorization", "   OAuth2    1234 ");
        Assert.assertEquals((Object)this.expectedToken, (Object)this.authHandler.getSecurityTokenFromRequest(this.req));
        this.req = new FakeHttpServletRequest("https://www.example.org/").setHeader("Authorization", "OAuth2 1234 x=1,y=\"2 2 2\"");
        Assert.assertEquals((Object)this.expectedToken, (Object)this.authHandler.getSecurityTokenFromRequest(this.req));
        this.req = new FakeHttpServletRequest("http://www.example.org/").setHeader("Authorization", "OAuth2 1234");
        Assert.assertNull((Object)this.authHandler.getSecurityTokenFromRequest(this.req));
    }

    @Test
    public void testOAuth2Param() throws Exception {
        this.req = new FakeHttpServletRequest("https://www.example.com?oauth_token=1234");
        Assert.assertEquals((Object)this.expectedToken, (Object)this.authHandler.getSecurityTokenFromRequest(this.req));
        this.req = new FakeHttpServletRequest("https://www.example.com?oauth_token=1234&oauth_signature_method=RSA-SHA1");
        Assert.assertNull((Object)this.authHandler.getSecurityTokenFromRequest(this.req));
    }
}

