/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.common.collect.ImmutableMap;
import org.apache.shindig.common.JsonSerializerTest;
import org.apache.shindig.common.JsonUtil;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilTest {
    @Test
    public void getPropertyOfJsonObject() throws Exception {
        JSONObject json = new JSONObject("{a: 1, b: '2'}");
        Assert.assertEquals((Object)1, (Object)JsonUtil.getProperty((Object)json, (String)"a"));
        Assert.assertEquals((Object)"2", (Object)JsonUtil.getProperty((Object)json, (String)"b"));
        Assert.assertNull((Object)JsonUtil.getProperty((Object)json, (String)"c"));
    }

    @Test
    public void getPropertyOfMap() throws Exception {
        ImmutableMap map = ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)"2");
        Assert.assertEquals((Object)1, (Object)JsonUtil.getProperty((Object)map, (String)"a"));
        Assert.assertEquals((Object)"2", (Object)JsonUtil.getProperty((Object)map, (String)"b"));
        Assert.assertNull((Object)JsonUtil.getProperty((Object)map, (String)"c"));
    }

    @Test
    public void getPropertyOfPojo() throws Exception {
        JsonSerializerTest.JsonPojo pojo = new JsonSerializerTest.JsonPojo();
        Assert.assertEquals((Object)"string-value", (Object)JsonUtil.getProperty((Object)pojo, (String)"string"));
        Assert.assertEquals((Object)100, (Object)JsonUtil.getProperty((Object)pojo, (String)"integer"));
        Assert.assertEquals((Object)3, (Object)JsonUtil.getProperty((Object)pojo, (String)"simple!"));
        Assert.assertNull((Object)JsonUtil.getProperty((Object)pojo, (String)"not"));
    }

    @Test
    public void excludedPropertiesOfPojo() throws Exception {
        JsonSerializerTest.JsonPojo pojo = new JsonSerializerTest.JsonPojo();
        Assert.assertNull((Object)JsonUtil.getProperty((Object)pojo, (String)"class"));
        Assert.assertNull((Object)JsonUtil.getProperty((Object)pojo, (String)"declaringClass"));
    }

    @Test
    public void duplicateMethodPojo() throws Exception {
        Duplicate pojo = new Duplicate();
        Assert.assertEquals((Object)"duplicate", (Object)JsonUtil.getProperty((Object)pojo, (String)"value"));
    }

    private class Duplicate
    extends DuplicateBase<String> {
        private Duplicate() {
        }

        @Override
        public String getValue() {
            return "duplicate";
        }
    }

    private class DuplicateBase<type> {
        private DuplicateBase() {
        }

        public type getValue() {
            return null;
        }
    }
}

