/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import org.apache.shindig.common.util.OpenSocialVersion;
import org.junit.Test;

public class OpenSocialVersionTest {
    @Test
    public void createOpenSocialVersion() {
        OpenSocialVersion version = new OpenSocialVersion("1.2.3");
        Assert.assertEquals((int)1, (int)version.major);
        Assert.assertEquals((int)2, (int)version.minor);
        Assert.assertEquals((int)3, (int)version.patch);
        Assert.assertEquals((Object)version, (Object)new OpenSocialVersion("1.2.3"));
    }

    @Test
    public void testEquivalence() {
        OpenSocialVersion version = new OpenSocialVersion("1.2.3");
        OpenSocialVersion version2 = new OpenSocialVersion("1.2");
        Assert.assertTrue((boolean)version.isEquivalent(version2));
        version = new OpenSocialVersion("2");
        Assert.assertTrue((boolean)version.isEquivalent("2.2"));
        version = new OpenSocialVersion("3");
        Assert.assertTrue((!version.isEquivalent("2.2") ? 1 : 0) != 0);
    }

    @Test
    public void testEqualOrGreaterThan() {
        OpenSocialVersion version = new OpenSocialVersion("1.2.3");
        OpenSocialVersion version2 = new OpenSocialVersion("1.2");
        Assert.assertTrue((boolean)version.isEqualOrGreaterThan(version2));
        Assert.assertTrue((!version2.isEqualOrGreaterThan(version) ? 1 : 0) != 0);
        version = new OpenSocialVersion("2");
        version2 = new OpenSocialVersion("2.2");
        Assert.assertTrue((!version.isEqualOrGreaterThan(version2) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)version2.isEqualOrGreaterThan(version));
        version = new OpenSocialVersion("2.2.48");
        version2 = new OpenSocialVersion("2.2.49");
        Assert.assertTrue((!version.isEqualOrGreaterThan(version2) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)version2.isEqualOrGreaterThan(version));
        version = new OpenSocialVersion("3");
        Assert.assertTrue((boolean)version.isEqualOrGreaterThan("2.2"));
        version = new OpenSocialVersion("3.1.18");
        Assert.assertTrue((boolean)version.isEqualOrGreaterThan("2.2"));
    }

    @Test
    public void testVersionSorting() {
        ArrayList<OpenSocialVersion> list = new ArrayList<OpenSocialVersion>();
        list.add(new OpenSocialVersion("2.2.48"));
        list.add(new OpenSocialVersion("9.0.1"));
        list.add(new OpenSocialVersion("1.2.48"));
        list.add(new OpenSocialVersion("2.3.48"));
        list.add(new OpenSocialVersion("2.2.455"));
        list.add(new OpenSocialVersion("9.0.0"));
        Collections.sort(list, OpenSocialVersion.COMPARATOR);
        for (int i = 0; i < list.size() - 1; ++i) {
            Assert.assertTrue((boolean)((OpenSocialVersion)list.get(i + 1)).isEqualOrGreaterThan((OpenSocialVersion)list.get(i)));
        }
    }
}

