/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.crypto;

import java.security.GeneralSecurityException;
import java.util.regex.Pattern;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.HMACType;
import org.junit.Assert;
import org.junit.Test;

public class CryptoTest {
    private BasicBlobCrypter crypter = new BasicBlobCrypter("0123456789abcdef".getBytes());

    public CryptoTest() {
        this.crypter.timeSource = new FakeTimeSource();
    }

    @Test
    public void testHmacSha1() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-21, 2, 47, -101, 9, -40, 18, 43, 76, 117, -51, 115, -122, -91, 39, 26, -18, 122, 30, 90};
        byte[] hmac = Crypto.hmacSha((byte[])key.getBytes(), (byte[])val.getBytes(), (String)HMACType.HMACSHA1.getName());
        Assert.assertArrayEquals((byte[])expected, (byte[])hmac);
    }

    @Test
    public void testHmacSha1Verify() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-21, 2, 47, -101, 9, -40, 18, 43, 76, 117, -51, 115, -122, -91, 39, 26, -18, 122, 30, 90};
        Crypto.hmacShaVerify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected, (String)HMACType.HMACSHA1.getName());
    }

    @Test
    public void testHmacSha256() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{69, -128, -5, 20, 94, -46, -40, 46, 43, -24, -76, -93, -28, -70, 3, 93, 101, 124, 111, -56, 124, -38, 103, 41, 83, -53, -45, 36, -21, 73, -10, -32};
        byte[] hmac = Crypto.hmacSha((byte[])key.getBytes(), (byte[])val.getBytes(), (String)HMACType.HMACSHA256.getName());
        Assert.assertArrayEquals((byte[])expected, (byte[])hmac);
    }

    @Test
    public void testHmacSha256Verify() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{69, -128, -5, 20, 94, -46, -40, 46, 43, -24, -76, -93, -28, -70, 3, 93, 101, 124, 111, -56, 124, -38, 103, 41, 83, -53, -45, 36, -21, 73, -10, -32};
        Crypto.hmacShaVerify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected, (String)HMACType.HMACSHA256.getName());
    }

    @Test
    public void testHmacSha384() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{66, -117, 24, -112, 19, -58, 80, 27, -117, 23, 107, 41, -118, -3, 100, -61, 42, 77, 50, 70, -28, 85, -39, -55, 47, 42, 106, 116, -26, 72, 76, -101, 67, -37, -56, 5, -85, 117, -51, -95, -18, -100, 81, 69, 9, 105, 70, 99};
        byte[] hmac = Crypto.hmacSha((byte[])key.getBytes(), (byte[])val.getBytes(), (String)HMACType.HMACSHA384.getName());
        Assert.assertArrayEquals((byte[])expected, (byte[])hmac);
    }

    @Test
    public void testHmacSha384Verify() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{66, -117, 24, -112, 19, -58, 80, 27, -117, 23, 107, 41, -118, -3, 100, -61, 42, 77, 50, 70, -28, 85, -39, -55, 47, 42, 106, 116, -26, 72, 76, -101, 67, -37, -56, 5, -85, 117, -51, -95, -18, -100, 81, 69, 9, 105, 70, 99};
        Crypto.hmacShaVerify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected, (String)HMACType.HMACSHA384.getName());
    }

    @Test
    public void testHmacSha512() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-40, -114, 57, 41, -97, -13, 13, 106, -71, 72, -54, 97, -50, -109, -115, -24, -68, 82, 73, -97, 46, -21, -128, -40, 73, 41, 43, 61, 20, 35, 79, 90, -27, 83, -1, -64, -128, 49, -118, -117, 34, -63, -51, 87, -85, 120, -9, -107, 29, 106, -48, 51, 105, -56, 86, -52, 18, -45, -81, -6, 0, 16, 67, 90};
        byte[] hmac = Crypto.hmacSha((byte[])key.getBytes(), (byte[])val.getBytes(), (String)HMACType.HMACSHA512.getName());
        Assert.assertArrayEquals((byte[])expected, (byte[])hmac);
    }

    @Test
    public void testHmacSha512Verify() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-40, -114, 57, 41, -97, -13, 13, 106, -71, 72, -54, 97, -50, -109, -115, -24, -68, 82, 73, -97, 46, -21, -128, -40, 73, 41, 43, 61, 20, 35, 79, 90, -27, 83, -1, -64, -128, 49, -118, -117, 34, -63, -51, 87, -85, 120, -9, -107, 29, 106, -48, 51, 105, -56, 86, -52, 18, -45, -81, -6, 0, 16, 67, 90};
        Crypto.hmacShaVerify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected, (String)HMACType.HMACSHA512.getName());
    }

    @Test(expected=GeneralSecurityException.class)
    public void testHmacSha1VerifyTampered() throws Exception {
        String key = "abcd1234";
        String val = "your mother is a hedgehog";
        byte[] expected = new byte[]{-21, 2, 47, -101, 9, -40, 18, 43, 76, 117, -51, 115, -122, -91, 39, 0, -18, 122, 30, 90};
        Crypto.hmacShaVerify((byte[])key.getBytes(), (byte[])val.getBytes(), (byte[])expected, (String)HMACType.HMACSHA1.getName());
    }

    @Test
    public void testAes128Cbc() throws Exception {
        byte[] key = Crypto.getRandomBytes((int)16);
        for (int i = 0; i < 50; i = (int)((byte)(i + 1))) {
            byte[] orig = new byte[i];
            for (int j = 0; j < i; j = (int)((byte)(j + 1))) {
                orig[j] = j;
            }
            byte[] cipherText = Crypto.aes128cbcEncrypt((byte[])key, (byte[])orig);
            byte[] plainText = Crypto.aes128cbcDecrypt((byte[])key, (byte[])cipherText);
            Assert.assertArrayEquals((String)("Array of length " + i), (byte[])orig, (byte[])plainText);
        }
    }

    @Test
    public void testRandomDigits() throws Exception {
        Pattern digitPattern = Pattern.compile("^\\d+$");
        String digits = Crypto.getRandomDigits((int)100);
        Assert.assertEquals((long)100L, (long)digits.length());
        Assert.assertTrue((String)("Should be only digits: " + digits), (boolean)digitPattern.matcher(digits).matches());
    }
}

