/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.servlet.BasicAuthority;
import org.junit.Test;

public class BasicAuthorityTest
extends EasyMockTestCase {
    @Test
    public void testBasicAuthorityWorks() {
        String host = "myhost";
        String port = "9080";
        BasicAuthority authority = new BasicAuthority(host, port);
        BasicAuthorityTest.assertEquals((Object)"myhost:9080", (Object)authority.getAuthority());
    }

    @Test
    public void testDefaultHostAndPort() {
        String host = "";
        String port = "";
        BasicAuthority authority = new BasicAuthority(host, port);
        BasicAuthorityTest.assertEquals((Object)"localhost:8080", (Object)authority.getAuthority());
    }

    @Test
    public void testJettyHostAndPort() {
        String host = "";
        String port = "";
        System.setProperty("jetty.host", "localhost");
        System.setProperty("jetty.port", "9003");
        BasicAuthority authority = new BasicAuthority(host, port);
        BasicAuthorityTest.assertEquals((Object)"localhost:9003", (Object)authority.getAuthority());
        System.clearProperty("jetty.host");
        System.clearProperty("jetty.port");
    }
}

