/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.servlet.HttpServletUserAgentProvider;
import org.apache.shindig.common.servlet.UserAgent;
import org.easymock.EasyMock;
import org.junit.Test;

public class HttpServletUserAgentProviderTest
extends EasyMockTestCase {
    private UserAgent.Parser parser = new PassThroughUAParser();

    @Test
    public void testProviderWorks() {
        String agentVersion = "AGENT_VERSION";
        HttpServletRequest req = this.mock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getHeader("User-Agent")).andReturn((Object)agentVersion).once();
        this.replay();
        HttpServletUserAgentProvider provider = new HttpServletUserAgentProvider(this.parser, (Provider)new HttpServletRequestProvider(req));
        UserAgent entry = provider.get();
        HttpServletUserAgentProviderTest.assertEquals((Object)UserAgent.Browser.OTHER, (Object)entry.getBrowser());
        HttpServletUserAgentProviderTest.assertEquals((Object)agentVersion, (Object)entry.getVersion());
        this.verify();
    }

    @Test
    public void testNoRequestGetsNull() {
        HttpServletUserAgentProvider provider = new HttpServletUserAgentProvider(this.parser, (Provider)new HttpServletRequestProvider(null));
        HttpServletUserAgentProviderTest.assertNull((Object)provider.get());
    }

    @Test
    public void testNoUserAgentGetsNull() {
        HttpServletRequest req = this.mock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getHeader("User-Agent")).andReturn(null).once();
        this.replay();
        HttpServletUserAgentProvider provider = new HttpServletUserAgentProvider(this.parser, (Provider)new HttpServletRequestProvider(req));
        HttpServletUserAgentProviderTest.assertNull((Object)provider.get());
        this.verify();
    }

    private static class PassThroughUAParser
    implements UserAgent.Parser {
        private PassThroughUAParser() {
        }

        public UserAgent parse(String agentVersion) {
            return new UserAgent(UserAgent.Browser.OTHER, agentVersion);
        }
    }

    private static class HttpServletRequestProvider
    implements Provider<HttpServletRequest> {
        private HttpServletRequest req;

        private HttpServletRequestProvider(HttpServletRequest req) {
            this.req = req;
        }

        public HttpServletRequest get() {
            return this.req;
        }
    }
}

