/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import junitx.framework.ComparableAssert;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.servlet.HttpServletResponseRecorder;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.common.util.TimeSource;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class HttpUtilTest {
    public static final FakeTimeSource timeSource = new FakeTimeSource();
    public static final long testStartTime = timeSource.currentTimeMillis();
    private HttpServletResponse mockResponse = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
    private HttpServletResponseRecorder recorder = new HttpServletResponseRecorder(this.mockResponse);

    @Test
    public void testSetCachingHeaders() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, HttpUtil.getDefaultTtl(), false);
    }

    @Test
    public void testSetCachingHeadersNoProxy() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (boolean)true);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, HttpUtil.getDefaultTtl(), true);
    }

    @Test
    public void testSetCachingHeadersAllowProxy() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (boolean)false);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, HttpUtil.getDefaultTtl(), false);
    }

    @Test
    public void testSetCachingHeadersFixedTtl() {
        int ttl = 10;
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (int)ttl);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, ttl, false);
    }

    @Test
    public void testSetCachingHeadersWithTtlAndNoProxy() {
        int ttl = 20;
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (int)ttl, (boolean)true);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, ttl, true);
    }

    @Test
    public void testSetCachingHeadersNoCache() {
        HttpUtil.setCachingHeaders((HttpServletResponse)this.recorder, (int)0);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, 0, true);
    }

    @Test
    public void testSetNoCche() {
        HttpUtil.setNoCache((HttpServletResponse)this.recorder);
        HttpUtilTest.checkCacheControlHeaders(testStartTime, this.recorder, 0, true);
    }

    @Test
    public void testCORSstar() {
        HttpUtil.setCORSheader((HttpServletResponse)this.recorder, Collections.singleton("*"));
        Assert.assertEquals((Object)this.recorder.getHeader("Access-Control-Allow-Origin"), (Object)"*");
    }

    @Test
    public void testCORSnull() {
        HttpUtil.setCORSheader((HttpServletResponse)this.recorder, null);
        Assert.assertEquals((Object)this.recorder.getHeader("Access-Control-Allow-Origin"), null);
    }

    @Test
    @Ignore(value="HttpServletResponseRecorder doesn't support multiple headers")
    public void testCORSmultiple() {
        HttpUtil.setCORSheader((HttpServletResponse)this.recorder, Arrays.asList("http://foo.example.com", "http://bar.example.com"));
    }

    public static void checkCacheControlHeaders(long testStartTime, HttpServletResponseRecorder response, int ttl, boolean noProxy) {
        long expires = DateUtil.parseRfc1123Date((String)response.getHeader("Expires")).getTime();
        long lowerBound = testStartTime + 1000L * (long)(ttl - 1);
        long upperBound = lowerBound + 2000L;
        ComparableAssert.assertGreater((String)("Expires should be at least " + ttl + " seconds more than start time."), (Comparable)Long.valueOf(lowerBound), (Comparable)Long.valueOf(expires));
        ComparableAssert.assertLesser((String)"Expires should be within 2 seconds of the requested value.", (Comparable)Long.valueOf(upperBound), (Comparable)Long.valueOf(expires));
        if (ttl == 0) {
            Assert.assertEquals((Object)"no-cache", (Object)response.getHeader("Pragma"));
            Assert.assertEquals((Object)"no-cache", (Object)response.getHeader("Cache-Control"));
        } else {
            List<String> directives = Arrays.asList(StringUtils.split((String)response.getHeader("Cache-Control"), (char)','));
            Assert.assertTrue((String)"Incorrect max-age set.", (boolean)directives.contains("max-age=" + ttl));
            if (noProxy) {
                Assert.assertTrue((String)"No private Cache-Control directive was set.", (boolean)directives.contains("private"));
            } else {
                Assert.assertTrue((String)"No public Cache-Control directive was set.", (boolean)directives.contains("public"));
            }
        }
    }

    static {
        HttpUtil.setTimeSource((TimeSource)timeSource);
    }
}

