/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.config.BasicContainerConfig;
import org.apache.shindig.config.ContainerConfig;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicContainerConfigTest {
    protected static final Map<String, Object> DEFAULT_CONTAINER = BasicContainerConfigTest.makeContainer("default", "inherited", "yes");
    protected static final Map<String, Object> MODIFIED_DEFAULT_CONTAINER = BasicContainerConfigTest.makeContainer("default", "inherited", "si");
    protected static final Map<String, Object> EXTRA_CONTAINER = BasicContainerConfigTest.makeContainer("extra", new Object[0]);
    protected static final Map<String, Object> MODIFIED_EXTRA_CONTAINER = BasicContainerConfigTest.makeContainer("extra", "inherited", "no");
    protected ContainerConfig config;

    protected static Map<String, Object> makeContainer(String name, Object ... values) {
        HashMap newCtr = Maps.newHashMap();
        newCtr.put("gadgets.container", ImmutableList.of((Object)name));
        for (int i = 0; i < values.length / 2; ++i) {
            newCtr.put(values[i * 2].toString(), values[i * 2 + 1]);
        }
        return Collections.unmodifiableMap(newCtr);
    }

    protected static Map<String, Object> makeContainer(List<String> name, Object ... values) {
        HashMap newCtr = Maps.newHashMap();
        newCtr.put("gadgets.container", name);
        for (int i = 0; i < values.length / 2; ++i) {
            newCtr.put(values[i * 2].toString(), values[i * 2 + 1]);
        }
        return Collections.unmodifiableMap(newCtr);
    }

    @Before
    public void setUp() throws Exception {
        this.config = new BasicContainerConfig();
        this.config.newTransaction().clearContainers().addContainer(DEFAULT_CONTAINER).commit();
    }

    @Test
    public void testGetContainers() throws Exception {
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"default", (Object)"extra"), (Object)this.config.getContainers());
    }

    @Test
    public void testGetProperties() throws Exception {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"gadgets.container", (Object)"inherited"), this.config.getProperties("default").keySet());
    }

    @Test
    public void testPropertyTypes() throws Exception {
        String container = "misc";
        this.config.newTransaction().addContainer(BasicContainerConfigTest.makeContainer("misc", "bool", true, "bool2", "true", "badbool", 1234, "badbool2", "notabool", "int", 1234, "int2", "1234", "badint", "notanint", "string", "abcd", "list", ImmutableList.of((Object)"a"), "badlist", "notalist", "map", ImmutableMap.of((Object)"a", (Object)"b"), "badmap", "notamap")).commit();
        Assert.assertEquals((Object)true, (Object)this.config.getBool(container, "bool"));
        Assert.assertEquals((Object)true, (Object)this.config.getBool(container, "bool2"));
        Assert.assertEquals((Object)false, (Object)this.config.getBool(container, "badbool"));
        Assert.assertEquals((Object)false, (Object)this.config.getBool(container, "badbool2"));
        Assert.assertEquals((long)1234L, (long)this.config.getInt(container, "int"));
        Assert.assertEquals((long)1234L, (long)this.config.getInt(container, "int2"));
        Assert.assertEquals((long)0L, (long)this.config.getInt(container, "badint"));
        Assert.assertEquals((Object)"abcd", (Object)this.config.getString(container, "string"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), (Object)this.config.getList(container, "list"));
        Assert.assertTrue((boolean)this.config.getList(container, "badlist").isEmpty());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)this.config.getMap(container, "map"));
        Assert.assertTrue((boolean)this.config.getMap(container, "badmap").isEmpty());
    }

    @Test
    public void testInheritance() throws Exception {
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("default", "inherited"));
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("extra", "inherited"));
        this.config.newTransaction().addContainer(MODIFIED_EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)"no", (Object)this.config.getString("extra", "inherited"));
        this.config.newTransaction().addContainer(MODIFIED_DEFAULT_CONTAINER).commit();
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertEquals((Object)"si", (Object)this.config.getString("extra", "inherited"));
        Assert.assertEquals((Object)"si", (Object)this.config.getString("extra", "inherited"));
    }

    @Test
    public void testContainersAreMergedRecursively() throws Exception {
        Map<String, Object> defaultContainer = BasicContainerConfigTest.makeContainer("default", "base", "/gadgets/foo", "user", "peter", "map", ImmutableMap.of((Object)"latitude", (Object)42, (Object)"longitude", (Object)-8), "data", ImmutableList.of((Object)"foo", (Object)"bar"));
        Map<String, Object> newContainer = BasicContainerConfigTest.makeContainer("new", "user", "anne", "colour", "green", "map", ImmutableMap.of((Object)"longitude", (Object)130), "data", null);
        Map<String, Object> expectedContainer = BasicContainerConfigTest.makeContainer("new", "base", "/gadgets/foo", "user", "anne", "colour", "green", "map", ImmutableMap.of((Object)"latitude", (Object)42, (Object)"longitude", (Object)130), "data", null);
        this.config.newTransaction().addContainer(defaultContainer).addContainer(newContainer).commit();
        Assert.assertEquals(expectedContainer, (Object)this.config.getProperties("new"));
    }

    @Test
    public void testNulledPropertiesRemainNulledAfterSeveralTransactions() throws Exception {
        Map<String, Object> defaultContainer = BasicContainerConfigTest.makeContainer("default", "o1", "v1", "o2", "v2", "o3", "v3");
        Map<String, Object> parentContainer = BasicContainerConfigTest.makeContainer("parent", "o3", null);
        Map<String, Object> childContainer = BasicContainerConfigTest.makeContainer("child", "parent", "parent", "o2", null);
        this.config.newTransaction().addContainer(defaultContainer).commit();
        this.config.newTransaction().addContainer(parentContainer).commit();
        this.config.newTransaction().addContainer(childContainer).commit();
        Assert.assertNull((Object)this.config.getProperty("child", "o2"));
        Assert.assertNull((Object)this.config.getProperty("child", "o3"));
        Assert.assertNull((Object)this.config.getProperty("parent", "o3"));
    }

    @Test
    public void testAddNewContainer() throws Exception {
        ContainerConfig.ConfigObserver observer = (ContainerConfig.ConfigObserver)EasyMock.createMock(ContainerConfig.ConfigObserver.class);
        observer.containersChanged((ContainerConfig)EasyMock.isA(ContainerConfig.class), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"extra")), (Collection)EasyMock.eq((Object)ImmutableSet.of()));
        EasyMock.replay((Object[])new Object[]{observer});
        this.config.addConfigObserver(observer, false);
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertTrue((boolean)this.config.getContainers().contains("extra"));
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("extra", "inherited"));
        EasyMock.verify((Object[])new Object[]{observer});
    }

    @Test
    public void testReplaceContainer() throws Exception {
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        ContainerConfig.ConfigObserver observer = (ContainerConfig.ConfigObserver)EasyMock.createMock(ContainerConfig.ConfigObserver.class);
        observer.containersChanged((ContainerConfig)EasyMock.isA(ContainerConfig.class), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"extra")), (Collection)EasyMock.eq((Object)ImmutableSet.of()));
        EasyMock.replay((Object[])new Object[]{observer});
        this.config.addConfigObserver(observer, false);
        this.config.newTransaction().addContainer(MODIFIED_EXTRA_CONTAINER).commit();
        Assert.assertTrue((boolean)this.config.getContainers().contains("extra"));
        Assert.assertEquals((Object)"no", (Object)this.config.getString("extra", "inherited"));
        EasyMock.verify((Object[])new Object[]{observer});
    }

    @Test
    public void testReadSameContainer() throws Exception {
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        ContainerConfig.ConfigObserver observer = (ContainerConfig.ConfigObserver)EasyMock.createMock(ContainerConfig.ConfigObserver.class);
        observer.containersChanged((ContainerConfig)EasyMock.isA(ContainerConfig.class), (Collection)EasyMock.eq((Object)ImmutableSet.of()), (Collection)EasyMock.eq((Object)ImmutableSet.of()));
        EasyMock.replay((Object[])new Object[]{observer});
        this.config.addConfigObserver(observer, false);
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        Assert.assertTrue((boolean)this.config.getContainers().contains("extra"));
        Assert.assertEquals((Object)"yes", (Object)this.config.getString("extra", "inherited"));
        EasyMock.verify((Object[])new Object[]{observer});
    }

    @Test
    public void testRemoveContainer() throws Exception {
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        this.config.newTransaction().addContainer(EXTRA_CONTAINER).commit();
        ContainerConfig.ConfigObserver observer = (ContainerConfig.ConfigObserver)EasyMock.createMock(ContainerConfig.ConfigObserver.class);
        observer.containersChanged((ContainerConfig)EasyMock.isA(ContainerConfig.class), (Collection)EasyMock.eq((Object)ImmutableSet.of()), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"extra")));
        EasyMock.replay((Object[])new Object[]{observer});
        this.config.addConfigObserver(observer, false);
        this.config.newTransaction().removeContainer("extra").commit();
        Assert.assertFalse((boolean)this.config.getContainers().contains("extra"));
        EasyMock.verify((Object[])new Object[]{observer});
    }

    @Test
    public void testClearContainerConfig() throws Exception {
        ContainerConfig.ConfigObserver observer = (ContainerConfig.ConfigObserver)EasyMock.createMock(ContainerConfig.ConfigObserver.class);
        observer.containersChanged((ContainerConfig)EasyMock.isA(ContainerConfig.class), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"additional")), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"extra")));
        EasyMock.replay((Object[])new Object[]{observer});
        this.config = new BasicContainerConfig();
        this.config.newTransaction().clearContainers().addContainer(DEFAULT_CONTAINER).addContainer(EXTRA_CONTAINER).commit();
        this.config.addConfigObserver(observer, false);
        this.config.newTransaction().clearContainers().addContainer(DEFAULT_CONTAINER).addContainer(BasicContainerConfigTest.makeContainer("additional", new Object[0])).commit();
        Assert.assertFalse((boolean)this.config.getContainers().contains("extra"));
        Assert.assertTrue((boolean)this.config.getContainers().contains("additional"));
        EasyMock.verify((Object[])new Object[]{observer});
    }

    @Test
    public void testAddObserverNotifiesImmediately() throws Exception {
        ContainerConfig.ConfigObserver observer = (ContainerConfig.ConfigObserver)EasyMock.createMock(ContainerConfig.ConfigObserver.class);
        observer.containersChanged((ContainerConfig)EasyMock.isA(ContainerConfig.class), (Collection)EasyMock.eq((Object)ImmutableSet.of((Object)"default", (Object)"extra")), (Collection)EasyMock.eq((Object)ImmutableSet.of()));
        EasyMock.replay((Object[])new Object[]{observer});
        this.config = new BasicContainerConfig();
        this.config.newTransaction().addContainer(DEFAULT_CONTAINER).addContainer(EXTRA_CONTAINER).commit();
        this.config.addConfigObserver(observer, true);
        EasyMock.verify((Object[])new Object[]{observer});
    }

    @Test
    public void testAliasesArePopulated() throws Exception {
        Map<String, Object> container = BasicContainerConfigTest.makeContainer((List<String>)ImmutableList.of((Object)"original", (Object)"alias"), "property", "value");
        this.config.newTransaction().addContainer(container).commit();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"default", (Object)"original", (Object)"alias"), (Object)this.config.getContainers());
        Assert.assertEquals((Object)"value", (Object)this.config.getString("original", "property"));
        Assert.assertEquals((Object)"value", (Object)this.config.getString("alias", "property"));
    }
}

