/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.config.ContainerConfigException;
import org.apache.shindig.config.ExpressionContainerConfig;
import org.apache.shindig.config.JsonContainerConfigLoader;
import org.apache.shindig.expressions.Expressions;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonContainerConfigLoaderTest {
    private static final String TOP_LEVEL_NAME = "Top level name";
    private static final String TOP_LEVEL_VALUE = "Top level value";
    private static final String NESTED_KEY = "ne$ted";
    private static final String NESTED_NAME = "Nested name";
    private static final String NESTED_VALUE = "Nested value";
    private static final String NESTED_ALT_VALUE = "Nested value alt";
    private static final String CHILD_CONTAINER = "child";
    private static final String CONTAINER_A = "container-a";
    private static final String CONTAINER_B = "container-b";
    private static final String ARRAY_NAME = "array value";
    private static final String[] ARRAY_VALUE = new String[]{"Hello", "World"};
    private static final String ARRAY_ALT_VALUE = "Not an array";
    public static final String DYNAMICALLY_LOADED_VALUE_KEY = "dynamicallyLoadedValueKey";
    private ExpressionContainerConfig config;

    private File createTemporaryFile(Object content, String extension) throws Exception {
        File file = File.createTempFile(this.getClass().getName(), extension);
        file.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(content.toString());
        out.close();
        return file;
    }

    private File createDefaultContainer() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put(TOP_LEVEL_NAME, (Object)TOP_LEVEL_VALUE);
        json.put(ARRAY_NAME, (Object)ARRAY_VALUE);
        JSONObject nested = new JSONObject();
        nested.put(NESTED_NAME, (Object)NESTED_VALUE);
        json.put(NESTED_KEY, (Object)nested);
        return this.createTemporaryFile(json, ".json");
    }

    private void createConfigForTest(String containers) throws ContainerConfigException {
        JsonContainerConfigLoader.getTransactionFromFile((String)containers, (String)"localhost", (String)"8080", (String)"", (ContainerConfig)this.config).commit();
    }

    @Before
    public void setUp() {
        this.config = new ExpressionContainerConfig(Expressions.forTesting());
    }

    @Test
    public void parseBasicConfig() throws Exception {
        this.createConfigForTest(this.createDefaultContainer().getAbsolutePath());
        Assert.assertEquals((long)1L, (long)this.config.getContainers().size());
        for (String container : this.config.getContainers()) {
            Assert.assertEquals((Object)"default", (Object)container);
        }
        String value = this.config.getString("default", TOP_LEVEL_NAME);
        Assert.assertEquals((Object)TOP_LEVEL_VALUE, (Object)value);
        Map nested = this.config.getMap("default", NESTED_KEY);
        String nestedValue = nested.get(NESTED_NAME).toString();
        Assert.assertEquals((Object)NESTED_VALUE, (Object)nestedValue);
    }

    @Test
    public void aliasesArePopulated() throws Exception {
        JSONObject json = new JSONObject().put("gadgets.container", (Object)new String[]{CONTAINER_A, CONTAINER_B}).put(NESTED_KEY, (Object)NESTED_VALUE);
        File parentFile = this.createDefaultContainer();
        File childFile = this.createTemporaryFile(json, ".json");
        this.createConfigForTest(childFile.getAbsolutePath() + ',' + parentFile.getAbsolutePath());
        Assert.assertEquals((Object)NESTED_VALUE, (Object)this.config.getString(CONTAINER_A, NESTED_KEY));
        Assert.assertEquals((Object)NESTED_VALUE, (Object)this.config.getString(CONTAINER_B, NESTED_KEY));
    }

    @Test
    public void parseWithDefaultInheritance() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{CHILD_CONTAINER});
        json.put("parent", (Object)"default");
        json.put(ARRAY_NAME, (Object)ARRAY_ALT_VALUE);
        JSONObject nested = new JSONObject();
        nested.put(NESTED_NAME, (Object)NESTED_ALT_VALUE);
        json.put(NESTED_KEY, (Object)nested);
        File childFile = this.createTemporaryFile(json, ".json");
        File parentFile = this.createDefaultContainer();
        this.createConfigForTest(childFile.getAbsolutePath() + ',' + parentFile.getAbsolutePath());
        String value = this.config.getString(CHILD_CONTAINER, TOP_LEVEL_NAME);
        Assert.assertEquals((Object)TOP_LEVEL_VALUE, (Object)value);
        Map nestedObj = this.config.getMap(CHILD_CONTAINER, NESTED_KEY);
        String nestedValue = nestedObj.get(NESTED_NAME).toString();
        Assert.assertEquals((Object)NESTED_ALT_VALUE, (Object)nestedValue);
        String arrayValue = this.config.getString(CHILD_CONTAINER, ARRAY_NAME);
        Assert.assertEquals((Object)ARRAY_ALT_VALUE, (Object)arrayValue);
        ArrayList<String> actual = new ArrayList<String>();
        for (Object val : this.config.getList("default", ARRAY_NAME)) {
            actual.add(val.toString());
        }
        List<String> expected = Arrays.asList(ARRAY_VALUE);
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void invalidContainerReturnsNull() throws Exception {
        this.createConfigForTest(this.createDefaultContainer().getAbsolutePath());
        Assert.assertNull((String)"Did not return null for invalid container.", (Object)this.config.getString("fake", "parent"));
    }

    @Test(expected=ContainerConfigException.class)
    public void badConfigThrows() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{CHILD_CONTAINER});
        json.put("parent", (Object)"bad bad bad parent!");
        json.put(ARRAY_NAME, (Object)ARRAY_ALT_VALUE);
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
    }

    @Test
    public void pathQuery() throws Exception {
        this.createConfigForTest(this.createDefaultContainer().getAbsolutePath());
        String path = "${ne$ted['Nested name']}";
        String data = this.config.getString("default", path);
        Assert.assertEquals((Object)NESTED_VALUE, (Object)data);
    }

    @Test
    public void expressionEvaluation() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put("expression", (Object)"Hello, ${world}!");
        json.put("world", (Object)"Earth");
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertEquals((Object)"Hello, Earth!", (Object)this.config.getString("default", "expression"));
    }

    @Test
    public void shindigPortTest() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put("expression", (Object)"port=${SERVER_PORT}");
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertEquals((Object)"port=8080", (Object)this.config.getString("default", "expression"));
    }

    @Test
    public void testCommonEnvironmentAddedToAllContainers() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default", "testContainer"});
        json.put("port", (Object)"${SERVER_PORT}");
        json.put("host", (Object)"${SERVER_HOST}");
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertEquals((Object)"8080", (Object)this.config.getString("default", "port"));
        Assert.assertEquals((Object)"8080", (Object)this.config.getString("testContainer", "port"));
        Assert.assertEquals((Object)"localhost", (Object)this.config.getString("default", "host"));
        Assert.assertEquals((Object)"localhost", (Object)this.config.getString("testContainer", "host"));
    }

    @Test
    public void expressionEvaluationUsingParent() throws Exception {
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{CHILD_CONTAINER});
        json.put("parent", (Object)"default");
        json.put("parentExpression", (Object)"${parent['Top level name']}");
        File childFile = this.createTemporaryFile(json, ".json");
        File parentFile = this.createDefaultContainer();
        this.createConfigForTest(childFile.getAbsolutePath() + ',' + parentFile.getAbsolutePath());
        Assert.assertEquals((Object)TOP_LEVEL_VALUE, (Object)this.config.getString(CHILD_CONTAINER, "parentExpression"));
    }

    @Test
    public void nullEntryEvaluation() throws Exception {
        JSONObject json = new JSONObject("{ 'gadgets.container' : ['default'], features : { osapi : null }}");
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertNull(this.config.getMap("default", "features").get("osapi"));
    }

    @Test
    public void testNullEntriesOverrideEntriesInParent() throws Exception {
        JSONObject parent = new JSONObject("{ 'gadgets.container' : ['default'], features : { osapi : 'foo' }}");
        JSONObject child = new JSONObject("{ 'gadgets.container' : ['child'], features : null}");
        JSONObject grand = new JSONObject("{ 'gadgets.container' : ['grand'], parent : 'child'}");
        this.createConfigForTest(this.createTemporaryFile(parent, ".json").getAbsolutePath());
        this.createConfigForTest(this.createTemporaryFile(child, ".json").getAbsolutePath());
        this.createConfigForTest(this.createTemporaryFile(grand, ".json").getAbsolutePath());
        Assert.assertEquals((Object)"foo", this.config.getMap("default", "features").get("osapi"));
        Assert.assertNull((Object)this.config.getProperty(CHILD_CONTAINER, "features"));
        Assert.assertNull((Object)this.config.getProperty("grand", "features"));
    }

    @Test
    public void resourceLoaderClasspathTest() throws Exception {
        String testFile = "classpath-accessible-test-file.txt";
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put(DYNAMICALLY_LOADED_VALUE_KEY, (Object)("res://" + testFile));
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertFalse((boolean)this.config.getString("default", DYNAMICALLY_LOADED_VALUE_KEY).startsWith("res://"));
        Assert.assertTrue((boolean)this.config.getString("default", DYNAMICALLY_LOADED_VALUE_KEY).contains(testFile));
    }

    @Test
    public void resourceLoaderFileTest() throws Exception {
        String dynamicValue = "dynamic value";
        File temporaryFile = this.createTemporaryFile(dynamicValue, ".txt");
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put(DYNAMICALLY_LOADED_VALUE_KEY, (Object)("file://" + temporaryFile.getAbsolutePath()));
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertEquals((Object)dynamicValue, (Object)this.config.getString("default", DYNAMICALLY_LOADED_VALUE_KEY).trim());
    }

    @Test
    public void resourceLoaderClasspathFailureTest() throws Exception {
        String invalidResource = "res://does-not-exist";
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put(DYNAMICALLY_LOADED_VALUE_KEY, (Object)invalidResource);
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertEquals((Object)invalidResource, (Object)this.config.getString("default", DYNAMICALLY_LOADED_VALUE_KEY));
    }

    @Test
    public void resourceLoaderFileFailureTest() throws Exception {
        String invalidResource = "file://does-not-exist";
        JSONObject json = new JSONObject();
        json.put("gadgets.container", (Object)new String[]{"default"});
        json.put(DYNAMICALLY_LOADED_VALUE_KEY, (Object)invalidResource);
        this.createConfigForTest(this.createTemporaryFile(json, ".json").getAbsolutePath());
        Assert.assertEquals((Object)invalidResource, (Object)this.config.getString("default", DYNAMICALLY_LOADED_VALUE_KEY));
    }
}

