/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.Service;
import org.junit.Ignore;

@Ignore
@Service(name="test", path="/{someParam}/{someOtherParam}")
public class TestHandler {
    public static final String GET_RESPONSE = "GET_RESPONSE";
    public static final String CREATE_RESPONSE = "CREATE_RESPONSE";
    public static final String FAILURE_MESSAGE = "FAILURE_MESSAGE";
    public static final String ECHO_PREFIX = "ECHO: ";
    public static final String NO_ARG_RESPONSE = "No arguments from me!";
    public static Map<String, String> REST_RESULTS = ImmutableMap.of((Object)"POST", (Object)"CREATE_RESPONSE", (Object)"GET", (Object)"GET_RESPONSE", (Object)"DELETE", (Object)"FAILURE_MESSAGE");
    private TestHandler mock;

    public void setMock(TestHandler mock) {
        this.mock = mock;
    }

    @Operation(httpMethods={"GET"})
    public Object get(RequestItem req) {
        if (this.mock != null) {
            return this.mock.get(req);
        }
        return GET_RESPONSE;
    }

    @Operation(httpMethods={"GET"}, path="/overridden/method")
    public Object overridden(RequestItem req) {
        if (this.mock != null) {
            return this.mock.get(req);
        }
        return GET_RESPONSE;
    }

    @Operation(name="override.rpcname", httpMethods={""})
    public Object overriddenRpc(RequestItem req) {
        if (this.mock != null) {
            return this.mock.get(req);
        }
        return GET_RESPONSE;
    }

    @Operation(httpMethods={"POST", "PUT"})
    public Future<?> create(RequestItem req) {
        if (this.mock != null) {
            return this.mock.create(req);
        }
        return Futures.immediateFuture((Object)CREATE_RESPONSE);
    }

    @Operation(httpMethods={"DELETE"})
    public Future<?> futureException(RequestItem req) {
        if (this.mock != null) {
            return this.mock.futureException(req);
        }
        return Futures.immediateFailedFuture((Throwable)new ProtocolException(400, FAILURE_MESSAGE, new Throwable()));
    }

    @Operation(httpMethods={})
    public void exception(RequestItem req) {
        if (this.mock == null) {
            throw new NullPointerException(FAILURE_MESSAGE);
        }
        this.mock.exception(req);
    }

    @Operation(httpMethods={"GET"}, path="/echo")
    public String echo(Input input) {
        return ECHO_PREFIX + input.value;
    }

    @Operation(httpMethods={""})
    public String noArg() {
        return NO_ARG_RESPONSE;
    }

    @Ignore
    public static class Input {
        public String value;

        public void setValue(String value) {
            this.value = value;
        }
    }
}

