/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.uri;

import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Uri {
    private final String text;
    private final String scheme;
    private final String authority;
    private final String path;
    private final String query;
    private final String fragment;
    private final Map<String, List<String>> queryParameters;

    Uri(UriBuilder builder) {
        this.scheme = builder.getScheme();
        this.authority = builder.getAuthority();
        this.path = builder.getPath();
        this.query = builder.getQuery();
        this.fragment = builder.getFragment();
        this.queryParameters = Collections.unmodifiableMap(Maps.newLinkedHashMap(builder.getQueryParameters()));
        StringBuilder out = new StringBuilder();
        if (this.scheme != null) {
            out.append(this.scheme).append(':');
        }
        if (this.authority != null) {
            out.append("//").append(this.authority);
        }
        if (this.path != null) {
            out.append(this.path);
        }
        if (this.query != null) {
            out.append('?').append(this.query);
        }
        if (this.fragment != null) {
            out.append('#').append(this.fragment);
        }
        this.text = out.toString();
    }

    public static Uri parse(String text) {
        try {
            return Uri.fromJavaUri(new URI(text));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Uri fromJavaUri(URI uri) {
        return new UriBuilder().setScheme(uri.getScheme()).setAuthority(uri.getRawAuthority()).setPath(uri.getRawPath()).setQuery(uri.getRawQuery()).setFragment(uri.getRawFragment()).toUri();
    }

    public URI toJavaUri() {
        try {
            return new URI(this.scheme, this.authority, this.path, this.query, this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Uri resolve(Uri other) {
        if (other == null) {
            return null;
        }
        return Uri.fromJavaUri(this.toJavaUri().resolve(other.toJavaUri()));
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public Collection<String> getQueryParameters(String name) {
        return this.queryParameters.get(name);
    }

    public String getQueryParameter(String name) {
        Collection values = this.queryParameters.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.iterator().next();
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Uri)) {
            return false;
        }
        return this.text.equals(((Uri)obj).text);
    }
}

