/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.xml;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final Logger LOG = Logger.getLogger(XmlUtil.class.getName());
    private static final ErrorHandler errorHandler = new ErrorHandler(){

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) {
            LOG.log(Level.INFO, "XmlUtil warning", exception);
        }
    };
    private static final List<DocumentBuilder> builderPool = Lists.newArrayList();
    private static boolean canUsePooling = false;
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    private XmlUtil() {
    }

    public static String getAttribute(Node node, String attr, String def) {
        NamedNodeMap attrs = node.getAttributes();
        Node val = attrs.getNamedItem(attr);
        if (val != null) {
            return val.getNodeValue();
        }
        return def;
    }

    public static String getAttribute(Node node, String attr) {
        return XmlUtil.getAttribute(node, attr, null);
    }

    public static Uri getUriAttribute(Node node, String attr, Uri def) {
        String uri = XmlUtil.getAttribute(node, attr);
        if (uri != null) {
            try {
                return Uri.parse(uri);
            }
            catch (IllegalArgumentException e) {
                return def;
            }
        }
        return def;
    }

    public static Uri getUriAttribute(Node node, String attr) {
        return XmlUtil.getUriAttribute(node, attr, null);
    }

    public static Uri getHttpUriAttribute(Node node, String attr, Uri def) {
        Uri uri = XmlUtil.getUriAttribute(node, attr, def);
        if (uri == null) {
            return def;
        }
        if (!"http".equalsIgnoreCase(uri.getScheme()) && !"https".equalsIgnoreCase(uri.getScheme())) {
            return def;
        }
        return uri;
    }

    public static Uri getHttpUriAttribute(Node node, String attr) {
        return XmlUtil.getHttpUriAttribute(node, attr, null);
    }

    public static boolean getBoolAttribute(Node node, String attr, boolean def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolAttribute(Node node, String attr) {
        return XmlUtil.getBoolAttribute(node, attr, false);
    }

    public static int getIntAttribute(Node node, String attr, int def) {
        String value = XmlUtil.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int getIntAttribute(Node node, String attr) {
        return XmlUtil.getIntAttribute(node, attr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getBuilderFromPool() throws ParserConfigurationException {
        DocumentBuilder builder;
        if (canUsePooling) {
            List<DocumentBuilder> list = builderPool;
            synchronized (list) {
                int size = builderPool.size();
                if (size > 0) {
                    builder = builderPool.remove(size - 1);
                    builder.reset();
                } else {
                    builder = builderFactory.newDocumentBuilder();
                }
            }
        } else {
            builder = builderFactory.newDocumentBuilder();
        }
        builder.setErrorHandler(errorHandler);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void returnBuilderToPool(DocumentBuilder builder) {
        if (canUsePooling) {
            List<DocumentBuilder> list = builderPool;
            synchronized (list) {
                builderPool.add(builder);
            }
        }
    }

    public static Element parse(String xml) throws XmlException {
        try {
            DocumentBuilder builder = XmlUtil.getBuilderFromPool();
            InputSource is = new InputSource(new StringReader(xml.trim()));
            Element element = builder.parse(is).getDocumentElement();
            XmlUtil.returnBuilderToPool(builder);
            return element;
        }
        catch (SAXParseException e) {
            throw new XmlException(e.getMessage() + " At: (" + e.getLineNumber() + ',' + e.getColumnNumber() + ')', e);
        }
        catch (SAXException e) {
            throw new XmlException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
        catch (IOException e) {
            throw new XmlException(e);
        }
    }

    static {
        builderFactory.setValidating(false);
        try {
            builderFactory.setAttribute("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            builderFactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            builderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            builderFactory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.reset();
            canUsePooling = true;
        }
        catch (UnsupportedOperationException e) {
            canUsePooling = false;
        }
        catch (ParserConfigurationException e) {
            canUsePooling = false;
        }
    }
}

