/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.testing.FakeHttpServletRequest;

public class AuthInfoTest
extends TestCase {
    public void testToken() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        FakeGadgetToken token = new FakeGadgetToken();
        AuthInfo info = new AuthInfo((HttpServletRequest)req).setSecurityToken((SecurityToken)token);
        AuthInfoTest.assertEquals((Object)token, (Object)info.getSecurityToken());
        AuthInfoTest.assertEquals((Object)token, (Object)new AuthInfo((HttpServletRequest)req).getSecurityToken());
    }

    public void testAuthType() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        AuthInfo info = new AuthInfo((HttpServletRequest)req).setAuthType("FakeAuth");
        AuthInfoTest.assertEquals((String)"FakeAuth", (String)info.getAuthType());
        AuthInfoTest.assertEquals((String)"FakeAuth", (String)new AuthInfo((HttpServletRequest)req).getAuthType());
    }

    public void testBinding() throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        FakeGadgetToken token = new FakeGadgetToken();
        new AuthInfo((HttpServletRequest)req).setSecurityToken((SecurityToken)token).setAuthType("FakeAuth");
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestModule(req)});
        AuthInfo injected = (AuthInfo)injector.getInstance(AuthInfo.class);
        AuthInfoTest.assertEquals((Object)token, (Object)injected.getSecurityToken());
        AuthInfoTest.assertEquals((String)"FakeAuth", (String)injected.getAuthType());
    }

    private static class TestModule
    extends AbstractModule {
        private HttpServletRequest req;

        public TestModule(HttpServletRequest req) {
            this.req = req;
        }

        protected void configure() {
            this.bind(HttpServletRequest.class).toInstance((Object)this.req);
        }
    }
}

