/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import org.apache.shindig.common.JsonSerializer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;

public final class JsonAssert {
    private JsonAssert() {
    }

    public static void assertJsonArrayEquals(JSONArray left, JSONArray right) throws Exception {
        if (left.length() != right.length()) {
            Assert.assertEquals((String)"Arrays are not of equal length", (Object)left.toString(), (Object)right.toString());
        }
        for (int i = 0; i < left.length(); ++i) {
            Object leftValue = left.opt(i);
            Object rightValue = right.opt(i);
            Assert.assertEquals((String)(left.toString() + " != " + right.toString()), leftValue.getClass(), rightValue.getClass());
            if (leftValue instanceof JSONObject) {
                JsonAssert.assertJsonObjectEquals((JSONObject)leftValue, (JSONObject)rightValue);
                continue;
            }
            if (leftValue instanceof JSONArray) {
                JsonAssert.assertJsonArrayEquals((JSONArray)leftValue, (JSONArray)rightValue);
                continue;
            }
            Assert.assertEquals((Object)leftValue, (Object)rightValue);
        }
    }

    public static void assertJsonObjectEquals(JSONObject left, JSONObject right) throws Exception {
        if (left.length() != right.length()) {
            Assert.assertEquals((String)"Objects are not of equal size", (Object)left.toString(2), (Object)right.toString(2));
        }
        if (JSONObject.getNames((JSONObject)left) == null && JSONObject.getNames((JSONObject)right) == null) {
            return;
        }
        for (String name : JSONObject.getNames((JSONObject)left)) {
            Object leftValue = left.opt(name);
            Object rightValue = right.opt(name);
            if (leftValue != null) {
                Assert.assertNotNull((String)(left.toString() + " != " + right.toString()), (Object)rightValue);
            }
            Assert.assertEquals((String)(left.toString() + " != " + right.toString()), leftValue.getClass(), rightValue.getClass());
            if (leftValue instanceof JSONObject) {
                JsonAssert.assertJsonObjectEquals((JSONObject)leftValue, (JSONObject)rightValue);
                continue;
            }
            if (leftValue instanceof JSONArray) {
                JsonAssert.assertJsonArrayEquals((JSONArray)leftValue, (JSONArray)rightValue);
                continue;
            }
            Assert.assertEquals((Object)leftValue, (Object)rightValue);
        }
    }

    public static void assertJsonEquals(String left, String right) throws Exception {
        switch (left.charAt(0)) {
            case '{': {
                JsonAssert.assertJsonObjectEquals(new JSONObject(left), new JSONObject(right));
                break;
            }
            case '[': {
                JsonAssert.assertJsonArrayEquals(new JSONArray(left), new JSONArray(right));
                break;
            }
            default: {
                Assert.assertEquals((Object)left, (Object)right);
            }
        }
    }

    public static void assertObjectEquals(Object left, Object right) throws Exception {
        if (!(left instanceof String)) {
            left = JsonSerializer.serialize((Object)left);
        }
        if (!(right instanceof String)) {
            right = JsonSerializer.serialize((Object)right);
        }
        JsonAssert.assertJsonEquals((String)left, (String)right);
    }
}

