/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.jsonlib;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.protocol.conversion.jsonlib.ApiValidatorException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiValidator {
    private static final Logger log = Logger.getLogger(ApiValidator.class.getName());
    private Context ctx = Context.enter();
    private ScriptableObject scope = this.ctx.initStandardObjects();

    public Map<String, Object> validate(String json, String object, String[] optionalFields, String[] nullfields) throws ApiValidatorException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading " + json);
        }
        if (!(json = json.trim()).endsWith("}")) {
            json = json + '}';
        }
        if (!json.startsWith("{")) {
            json = '{' + json;
        }
        json = "( testingObject = " + json + " )";
        Object so = null;
        try {
            so = this.ctx.evaluateString((Scriptable)this.scope, json, "test json", 0, null);
        }
        catch (EvaluatorException ex) {
            log.severe("Non parseable JSON " + json);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loaded " + so);
        }
        ScriptableObject specification = this.getScriptableObject(object);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking for  " + object + " found " + specification);
        }
        this.listScriptable(object, specification);
        Object[] fields = specification.getIds();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Object fieldName = specification.get(String.valueOf(fields[i]), (Scriptable)specification);
            fieldNames[i] = String.valueOf(fieldName);
        }
        return this.validateObject(so, fieldNames, optionalFields, nullfields);
    }

    public Map<String, Object> validate(String json, String[] fieldNames, String[] optionalFields, String[] nullfields) throws ApiValidatorException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading " + json);
        }
        if (!(json = json.trim()).endsWith("}")) {
            json = json + '}';
        }
        if (!json.startsWith("{")) {
            json = '{' + json;
        }
        json = "( testingObject = " + json + " )";
        Object so = null;
        try {
            so = this.ctx.evaluateString((Scriptable)this.scope, json, "test json", 0, null);
        }
        catch (EvaluatorException ex) {
            log.severe("Non parseable JSON " + json);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loaded " + so);
        }
        return this.validateObject(so, fieldNames, optionalFields, nullfields);
    }

    public Map<String, Object> validateObject(Object jsonObject, String[] fieldNames, String[] optionalFields, String[] nullFields) throws ApiValidatorException {
        HashMap optional = Maps.newHashMap();
        for (String opt : optionalFields) {
            optional.put(opt, opt);
        }
        HashMap nullf = Maps.newHashMap();
        for (String nf : nullFields) {
            nullf.put(nf, nf);
        }
        HashMap resultFields = Maps.newHashMap();
        if (jsonObject instanceof ScriptableObject) {
            ScriptableObject parsedJSONObject = (ScriptableObject)jsonObject;
            this.listScriptable("testingObject", parsedJSONObject);
            for (String fieldName : fieldNames) {
                Object o = parsedJSONObject.get(fieldName, (Scriptable)parsedJSONObject);
                if (o == Scriptable.NOT_FOUND) {
                    if (optional.containsKey(fieldName)) {
                        log.warning("Missing Optional Field " + fieldName);
                        continue;
                    }
                    if (nullf.containsKey(fieldName)) continue;
                    log.severe("Missing Field " + fieldName);
                    throw new ApiValidatorException("Missing Field " + fieldName);
                }
                if (nullf.containsKey(fieldName)) {
                    log.severe("Field should have been null and was not");
                }
                if (o == null) {
                    if (nullf.containsKey(fieldName)) {
                        log.severe("Null Fields has been serialized " + fieldName);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Got a Null object for Field " + fieldName + " on json [[" + jsonObject + "]]");
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("Got JSON Field  Field," + fieldName + " as " + o + ' ' + o.getClass());
                }
                resultFields.put(String.valueOf(fieldName), o);
            }
        } else {
            throw new ApiValidatorException("Parsing JSON resulted in invalid Javascript object, which was " + jsonObject + " JSON was [[" + jsonObject + "]]");
        }
        return resultFields;
    }

    private ScriptableObject getScriptableObject(String object) {
        String[] path = object.split("\\.");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking up " + object + " elements " + path.length);
        }
        ScriptableObject s = this.scope;
        for (String pe : path) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Looking up " + pe + " in " + s);
            }
            s = (ScriptableObject)s.get(pe, (Scriptable)s);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Looking for " + pe + " in found " + s);
        }
        return s;
    }

    private void listScriptable(String id, ScriptableObject scriptableObject) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ID is Scriptable " + id);
        }
        if (!id.endsWith("constructor")) {
            Object[] allIDs;
            for (Object oid : allIDs = scriptableObject.getAllIds()) {
                Object o;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(id + '.' + oid);
                }
                if (!((o = scriptableObject.get(String.valueOf(oid), (Scriptable)scriptableObject)) instanceof ScriptableObject)) continue;
                this.listScriptable(id + '.' + oid, (ScriptableObject)o);
            }
        }
    }

    public void addScript(String javascript) {
        Script compileScript = this.ctx.compileString(javascript, "AdditionalJS", 0, null);
        compileScript.exec(this.ctx, (Scriptable)this.scope);
    }

    public static void dump(Map<?, ?> nameJSON) {
        if (log.isLoggable(Level.INFO)) {
            for (Map.Entry<?, ?> entry : nameJSON.entrySet()) {
                Object k = entry.getKey();
                Object o = entry.getValue();
                log.info("Key [" + k + "] value:[" + (o == null ? "null" : o + ":" + o.getClass()) + ']');
            }
        }
    }
}

