function DateTimeParseTest(a){TestCase.call(this,a)}DateTimeParseTest.inherits(TestCase);var DateTimeConstants_en={ERAS:["BC","AD"],ERANAMES:["Before Christ","Anno Domini"],NARROWMONTHS:["J","F","M","A","M","J","J","A","S","O","N","D"],MONTHS:["January","February","March","April","May","June","July","August","September","October","November","December"],SHORTMONTHS:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],WEEKDAYS:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],SHORTWEEKDAYS:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],NARROWWEEKDAYS:["S","M","T","W","T","F","S"],SHORTQUARTERS:["Q1","Q2","Q3","Q4"],QUARTERS:["1st quarter","2nd quarter","3rd quarter","4th quarter"],AMPMS:["AM","PM"],DATEFORMATS:["EEEE, MMMM d, yyyy","MMMM d, yyyy","MMM d, yyyy","M/d/yy"],TIMEFORMATS:["h:mm:ss a v","h:mm:ss a z","h:mm:ss a","h:mm a"],ZONESTRINGS:null};DateTimeConstants_en.STANDALONENARROWMONTHS=DateTimeConstants_en.NARROWMONTHS;DateTimeConstants_en.STANDALONEMONTHS=DateTimeConstants_en.MONTHS;DateTimeConstants_en.STANDALONESHORTMONTHS=DateTimeConstants_en.SHORTMONTHS;DateTimeConstants_en.STANDALONEWEEKDAYS=DateTimeConstants_en.WEEKDAYS;DateTimeConstants_en.STANDALONESHORTWEEKDAYS=DateTimeConstants_en.SHORTWEEKDAYS;DateTimeConstants_en.STANDALONENARROWWEEKDAYS=DateTimeConstants_en.NARROWWEEKDAYS;DateTimeParseTest.prototype.setUp=function(){gadgets.i18n.dtParser_=new gadgets.i18n.DateTimeParse(DateTimeConstants_en)};DateTimeParseTest.prototype.testNegativeYear=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("MM/dd, yyyy","11/22, 1999",0,a)>0);this.assertEquals(1999,a.getFullYear());this.assertEquals(11-1,a.getMonth());this.assertEquals(22,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("MM/dd, yyyy","11/22, -1999",0,a)>0);this.assertEquals(-1999,a.getFullYear());this.assertEquals(11-1,a.getMonth());this.assertEquals(22,a.getDate())};DateTimeParseTest.prototype.testEra=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("MM/dd, yyyyG","11/22, 1999BC",0,a)>0);this.assertEquals(-1998,a.getFullYear());this.assertEquals(11-1,a.getMonth());this.assertEquals(22,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("MM/dd, yyyyG","11/22, 1BC",0,a)>0);this.assertEquals(0,a.getFullYear());this.assertEquals(11-1,a.getMonth());this.assertEquals(22,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("MM/dd, yyyyG","11/22, 1999AD",0,a)>0);this.assertEquals(1999,a.getFullYear());this.assertEquals(11-1,a.getMonth());this.assertEquals(22,a.getDate())};DateTimeParseTest.prototype.testFractionalSeconds=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("hh:mm:ss.SSS","11:12:13.956",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(12,a.getMinutes());this.assertEquals(13,a.getSeconds());this.assertEquals(956,a.getTime()%1000);this.assertTrue(gadgets.i18n.parseDateTime("hh:mm:ss.SSS","11:12:13.95",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(12,a.getMinutes());this.assertEquals(13,a.getSeconds());this.assertEquals(950,a.getTime()%1000);this.assertTrue(gadgets.i18n.parseDateTime("hh:mm:ss.SSS","11:12:13.9",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(12,a.getMinutes());this.assertEquals(13,a.getSeconds());this.assertEquals(900,a.getTime()%1000)};DateTimeParseTest.prototype.testAmbiguousYear=function(){var a=new Date();var b=new Date();b.setFullYear(b.getFullYear()+20);b.setMonth(0);b.setDate(1);b.setHours(0);b.setMinutes(0);b.setSeconds(0);b.setMilliseconds(1);var c="01/01/"+(b.getFullYear()%100);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yy",c,0,a)>0);this.assertEquals(b.getFullYear(),a.getFullYear());b.setMonth(11);b.setDate(31);b.setHours(23);b.setMinutes(59);b.setSeconds(59);b.setMilliseconds(999);c="12/31/"+(b.getFullYear()%100);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yy",c,0,a)>0);this.assertEquals(b.getFullYear(),a.getFullYear()+100);this.assertTrue(gadgets.i18n.parseDateTime("yy,MM,dd","2097,07,21",0,a)>0);this.assertEquals(2097,a.getFullYear());gadgets.i18n.DateTimeParse.ambiguousYearCenturyStart=60;b.setMonth(0);b.setDate(1);b.setHours(0);b.setMinutes(0);b.setSeconds(0);b.setMilliseconds(1);c="01/01/"+(b.getFullYear()%100);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yy",c,0,a)>0);this.assertEquals(b.getFullYear(),a.getFullYear());b.setFullYear(a.getFullYear()+20);c="01/01/"+(b.getFullYear()%100);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yy",c,0,a)>0);this.assertEquals(b.getFullYear(),a.getFullYear());b.setFullYear(a.getFullYear()+21);c="01/01/"+(b.getFullYear()%100);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yy",c,0,a)>0);this.assertEquals(b.getFullYear(),a.getFullYear()+100);gadgets.i18n.DateTimeParse.ambiguousYearCenturyStart=80};DateTimeParseTest.prototype.testLeapYear=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("MMdd, yyyy","0229, 2001",0,a)>0);this.assertEquals(3-1,a.getMonth());this.assertEquals(1,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("MMdd, yyyy","0229, 2000",0,a)>0);this.assertEquals(2-1,a.getMonth());this.assertEquals(29,a.getDate())};DateTimeParseTest.prototype.testAbutField=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("hhmm","1122",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmm","122",0,a)>0);this.assertEquals(1,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmmss","112233",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertEquals(33,a.getSeconds());this.assertTrue(gadgets.i18n.parseDateTime("hhmmss","12233",0,a)>0);this.assertEquals(1,a.getHours());this.assertEquals(22,a.getMinutes());this.assertEquals(33,a.getSeconds());this.assertTrue(gadgets.i18n.parseDateTime("yyyyMMdd","19991202",0,a)>0);this.assertEquals(1999,a.getFullYear());this.assertEquals(12-1,a.getMonth());this.assertEquals(2,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("yyyyMMdd","9991202",0,a)>0);this.assertTrue(a.getFullYear()==999);this.assertEquals(12-1,a.getMonth());this.assertEquals(2,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("yyyyMMdd","991202",0,a)>0);this.assertEquals(99,a.getFullYear());this.assertEquals(12-1,a.getMonth());this.assertEquals(2,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("yyyyMMdd","91202",0,a)>0);this.assertEquals(9,a.getFullYear());this.assertEquals(12-1,a.getMonth());this.assertEquals(2,a.getDate())};DateTimeParseTest.prototype.testYearParsing=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("yyMMdd","991202",0,a)>0);this.assertEquals(1999,a.getFullYear());this.assertEquals(12-1,a.getMonth());this.assertEquals(2,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("yyyyMMdd","20051202",0,a)>0);this.assertEquals(2005,a.getFullYear());this.assertEquals(12-1,a.getMonth());this.assertEquals(2,a.getDate())};DateTimeParseTest.prototype.testHourParsing_hh=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("hhmm","0022",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmm","1122",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmm","1222",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmm","2322",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmm","2422",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","0022am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","1122am",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","1222am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","2322am",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","2422am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","0022pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","1122pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","1222pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","2322pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("hhmma","2422pm",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes())};DateTimeParseTest.prototype.testHourParsing_KK=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("KKmm","0022",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmm","1122",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmm","1222",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmm","2322",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmm","2422",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","0022am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","1122am",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","1222am",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","2322am",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","2422am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","0022pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","1122pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","1222pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","2322pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("KKmma","2422pm",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes())};DateTimeParseTest.prototype.testHourParsing_kk=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("kkmm","0022",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmm","1122",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmm","1222",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmm","2322",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmm","2422",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","0022am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","1122am",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","1222am",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","2322am",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","2422am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","0022pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","1122pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","1222pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","2322pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("kkmma","2422pm",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes())};DateTimeParseTest.prototype.testHourParsing_HH=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("HHmm","0022",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmm","1122",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmm","1222",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmm","2322",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmm","2422",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","0022am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","1122am",0,a)>0);this.assertEquals(11,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","1222am",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","2322am",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","2422am",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","0022pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","1122pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","1222pm",0,a)>0);this.assertEquals(12,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","2322pm",0,a)>0);this.assertEquals(23,a.getHours());this.assertEquals(22,a.getMinutes());this.assertTrue(gadgets.i18n.parseDateTime("HHmma","2422pm",0,a)>0);this.assertEquals(0,a.getHours());this.assertEquals(22,a.getMinutes())};DateTimeParseTest.prototype.testEnglishDate=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("yyyy MMM dd hh:mm","2006 Jul 10 15:44",0,a)>0);this.assertEquals(2006,a.getFullYear());this.assertEquals(7-1,a.getMonth());this.assertEquals(10,a.getDate());this.assertEquals(15,a.getHours());this.assertEquals(44,a.getMinutes())};DateTimeParseTest.prototype.testTimeZone=function(){var e=new Date();this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yyyy, hh:mm:ss zzz","07/21/2003, 11:22:33 GMT-0700",0,e)>0);var c=e.getHours();this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yyyy, hh:mm:ss zzz","07/21/2003, 11:22:33 GMT-0600",0,e)>0);var d=e.getHours();this.assertEquals(1,(c+24-d)%24);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yyyy, hh:mm:ss zzz","07/21/2003, 11:22:33 GMT-0800",0,e)>0);var b=e.getHours();this.assertEquals(1,(b+24-c)%24);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yyyy, HH:mm:ss zzz","07/21/2003, 23:22:33 GMT-0800",0,e)>0);this.assertEquals((e.getHours()+24-c)%24,13);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yyyy, HH:mm:ss zzz","07/21/2003, 11:22:33 GMT+0800",0,e)>0);var a=e.getHours();this.assertEquals(16,(b+24-a)%24);this.assertTrue(gadgets.i18n.parseDateTime("MM/dd/yyyy, HH:mm:ss zzz","07/21/2003, 11:22:33 GMT0800",0,e)>0);this.assertEquals(a,e.getHours())};DateTimeParseTest.prototype.testWeekDay=function(){var a=new Date();this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/dd/yyyy","Wednesday, 08/16/2006",0,a)>0);this.assertEquals(2006,a.getFullYear());this.assertEquals(8-1,a.getMonth());this.assertEquals(16,a.getDate());this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/dd/yyyy","Tuesday, 08/16/2006",0,a)==0);this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/dd/yyyy","Thursday, 08/16/2006",0,a)==0);this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/dd/yyyy","Wed, 08/16/2006",0,a)>0);this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/dd/yyyy","Wasdfed, 08/16/2006",0,a)==0);a.setDate(25);this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/yyyy","Wed, 09/2006",0,a)>0);this.assertEquals(27,a.getDate());a.setDate(30);this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/yyyy","Wed, 09/2006",0,a)>0);this.assertEquals(27,a.getDate());a.setDate(30);this.assertTrue(gadgets.i18n.parseDateTime("EEEE, MM/yyyy","Mon, 09/2006",0,a)>0);this.assertEquals(25,a.getDate())};