/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.preload.HttpPreloader;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.render.RenderingContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.DefaultContentRewriter;
import org.apache.shindig.gadgets.servlet.CajaContentRewriter;

public class DefaultGuiceModule
extends AbstractModule {
    protected void configure() {
        ExecutorService service = Executors.newCachedThreadPool();
        this.bind(Executor.class).toInstance((Object)service);
        this.bind(ExecutorService.class).toInstance((Object)service);
        this.install((Module)new ParseModule());
        this.bind((TypeLiteral)new TypeLiteral<List<ContentRewriter>>(){}).toProvider(ContentRewritersProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<List<Preloader>>(){}).toProvider(PreloaderProvider.class);
        this.requestStaticInjection(new Class[]{HttpResponse.class});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreloaderProvider
    implements Provider<List<Preloader>> {
        private final List<Preloader> preloaders;

        @Inject
        public PreloaderProvider(HttpPreloader httpPreloader) {
            this.preloaders = Lists.newArrayList((Object[])new Preloader[]{httpPreloader});
        }

        public List<Preloader> get() {
            return this.preloaders;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContentRewritersProvider
    implements Provider<List<ContentRewriter>> {
        private final List<ContentRewriter> rewriters = Lists.newArrayList();

        @Inject
        public ContentRewritersProvider(DefaultContentRewriter optimizingRewriter, CajaContentRewriter cajaRewriter, RenderingContentRewriter renderingRewriter) {
            this.rewriters.add(optimizingRewriter);
            this.rewriters.add(cajaRewriter);
            this.rewriters.add(renderingRewriter);
        }

        public List<ContentRewriter> get() {
            return this.rewriters;
        }
    }
}

