/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.json.JSONArray;

public class HttpCacheKey {
    private Map<String, String> data = new HashMap<String, String>();
    private boolean cacheable;

    public HttpCacheKey(HttpRequest request) {
        this.setCacheable(true);
        if (!"GET".equals(request.getMethod()) || request.getIgnoreCache()) {
            this.setCacheable(false);
        }
        this.set("method", request.getMethod());
        this.set("url", request.getUri().toString());
    }

    public void set(String key, String value) {
        this.data.put(key, value);
    }

    public void remove(String key) {
        this.data.remove(key);
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.data.keySet());
        Collections.sort(list);
        JSONArray json = new JSONArray();
        for (String key : list) {
            json.put(Collections.singletonMap(key, this.data.get(key)));
        }
        return json.toString();
    }
}

