/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPref {
    private final String name;
    private String displayName;
    private String defaultValue;
    private final boolean required;
    private final DataType dataType;
    private Map<String, String> enumValues;
    private List<EnumValuePair> orderedEnumValues;

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getRequired() {
        return this.required;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getEnumValues() {
        return this.enumValues;
    }

    public List<EnumValuePair> getOrderedEnumValues() {
        return this.orderedEnumValues;
    }

    public UserPref substitute(Substitutions substituter) {
        UserPref pref = new UserPref(this);
        pref.displayName = substituter.substituteString(this.displayName);
        pref.defaultValue = substituter.substituteString(this.defaultValue);
        if (this.enumValues.isEmpty()) {
            pref.enumValues = Collections.emptyMap();
        } else {
            HashMap values = new HashMap(this.enumValues.size());
            for (Map.Entry entry : this.enumValues.entrySet()) {
                values.put(entry.getKey(), substituter.substituteString((String)entry.getValue()));
            }
            pref.enumValues = Collections.unmodifiableMap(values);
        }
        if (this.orderedEnumValues.isEmpty()) {
            pref.orderedEnumValues = Collections.emptyList();
        } else {
            LinkedList<EnumValuePair> orderedValues = new LinkedList<EnumValuePair>();
            for (EnumValuePair enumValuePair : this.orderedEnumValues) {
                orderedValues.add(new EnumValuePair(enumValuePair.getValue(), substituter.substituteString(enumValuePair.getDisplayValue())));
            }
            pref.orderedEnumValues = Collections.unmodifiableList(orderedValues);
        }
        return pref;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<UserPref name=\"").append(this.name).append("\" display_name=\"").append(this.displayName).append("\" default_value=\"").append(this.defaultValue).append("\" required=\"").append(this.required).append("\" datatype=\"").append(this.dataType.toString().toLowerCase()).append('\"');
        if (this.enumValues.isEmpty()) {
            buf.append("/>");
        } else {
            buf.append('\n');
            for (Map.Entry<String, String> entry : this.enumValues.entrySet()) {
                buf.append("<EnumValue value=\"").append(entry.getKey()).append("\" value=\"").append("\" display_value=\"").append(entry.getValue()).append("\"/>\n");
            }
            buf.append("</UserPref>");
        }
        return buf.toString();
    }

    public UserPref(Element element) throws SpecParserException {
        String name = XmlUtil.getAttribute((Node)element, (String)"name");
        if (name == null) {
            throw new SpecParserException("UserPref@name is required.");
        }
        this.name = name;
        this.displayName = XmlUtil.getAttribute((Node)element, (String)"display_name", (String)name);
        this.defaultValue = XmlUtil.getAttribute((Node)element, (String)"default_value", (String)"");
        this.required = XmlUtil.getBoolAttribute((Node)element, (String)"required");
        String dataType = XmlUtil.getAttribute((Node)element, (String)"datatype", (String)"string");
        this.dataType = DataType.parse(dataType);
        NodeList children = element.getElementsByTagName("EnumValue");
        if (children.getLength() > 0) {
            HashMap<String, String> enumValues = new HashMap<String, String>();
            LinkedList<EnumValuePair> orderedEnumValues = new LinkedList<EnumValuePair>();
            int j = children.getLength();
            for (int i = 0; i < j; ++i) {
                Element child = (Element)children.item(i);
                String value = XmlUtil.getAttribute((Node)child, (String)"value");
                if (value == null) {
                    throw new SpecParserException("EnumValue@value is required.");
                }
                String displayValue = XmlUtil.getAttribute((Node)child, (String)"display_value", (String)value);
                enumValues.put(value, displayValue);
                orderedEnumValues.add(new EnumValuePair(value, displayValue));
            }
            this.enumValues = Collections.unmodifiableMap(enumValues);
            this.orderedEnumValues = Collections.unmodifiableList(orderedEnumValues);
        } else {
            this.enumValues = Collections.emptyMap();
            this.orderedEnumValues = Collections.emptyList();
        }
    }

    private UserPref(UserPref userPref) {
        this.name = userPref.name;
        this.dataType = userPref.dataType;
        this.required = userPref.required;
    }

    public static class EnumValuePair {
        private final String value;
        private final String displayValue;

        private EnumValuePair(String value, String displayValue) {
            this.value = value;
            this.displayValue = displayValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        STRING,
        HIDDEN,
        BOOL,
        ENUM,
        LIST,
        NUMBER;


        public static DataType parse(String value) {
            for (DataType type : DataType.values()) {
                if (type.toString().compareToIgnoreCase(value) != 0) continue;
                return type;
            }
            return STRING;
        }
    }
}

