/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import java.util.Date;
import junit.framework.TestCase;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.gadgets.http.DefaultHttpCache;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

public class DefaultHttpCacheTest
extends TestCase {
    private HttpCache cache;

    public void setUp() throws Exception {
        super.setUp();
        this.cache = new DefaultHttpCache(this.getCacheProvider());
    }

    protected void tearDown() throws Exception {
        this.cache = null;
        super.tearDown();
    }

    protected CacheProvider getCacheProvider() throws Exception {
        return new LruCacheProvider(5);
    }

    private static HttpRequest createRequest(String method) {
        return new HttpRequest(Uri.parse((String)"http://www.example.org")).setMethod(method);
    }

    private static HttpResponse createResponse(int statusCode, String header, String headerValue) {
        return new HttpResponseBuilder().setHttpStatusCode(statusCode).addHeader(header, headerValue).create();
    }

    private HttpResponse createExpiresResponse(int statusCode, long expiration) {
        Date newExpiry = new Date(expiration);
        return DefaultHttpCacheTest.createResponse(statusCode, "Expires", DateUtil.formatDate((Date)newExpiry));
    }

    private HttpResponse createMaxAgeResponse(int statusCode, long age) {
        return DefaultHttpCacheTest.createResponse(statusCode, "Cache-Control", "max-age=" + age);
    }

    public void testEmptyCache() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpCacheKey key = new HttpCacheKey(req);
        DefaultHttpCacheTest.assertNull((Object)this.cache.getResponse(key, req));
    }

    public void testCacheable() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = DefaultHttpCacheTest.createResponse(200, null, null);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertEquals((Object)resp, (Object)this.cache.getResponse(key, req));
    }

    public void testNotCacheableForPost() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("POST");
        HttpResponse resp = DefaultHttpCacheTest.createResponse(200, null, null);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertNull((Object)this.cache.getResponse(key, req));
    }

    public void testCacheableForErr() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = DefaultHttpCacheTest.createResponse(500, null, null);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertEquals((Object)resp, (Object)this.cache.getResponse(key, req));
    }

    public void testCacheableForFutureExpires() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = this.createExpiresResponse(200, System.currentTimeMillis() + 10000L);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertEquals((Object)resp, (Object)this.cache.getResponse(key, req));
    }

    public void testNotCacheableForPastExpires() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = this.createExpiresResponse(200, System.currentTimeMillis() - 10000L);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertNull((Object)this.cache.getResponse(key, req));
    }

    public void testCacheableForFutureMaxAge() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = this.createMaxAgeResponse(200, 10000L);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertEquals((Object)resp, (Object)this.cache.getResponse(key, req));
    }

    public void testNotCacheableForNoCache() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = DefaultHttpCacheTest.createResponse(200, "Cache-Control", "no-cache");
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        DefaultHttpCacheTest.assertNull((Object)this.cache.getResponse(key, req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheableForExpiresWithWait() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = this.createExpiresResponse(200, System.currentTimeMillis() + 5000L);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        try {
            HttpCache httpCache = this.cache;
            synchronized (httpCache) {
                this.cache.wait(500L);
            }
        }
        catch (InterruptedException ie) {
            DefaultHttpCacheTest.fail((String)"Failed to wait for cache");
        }
        DefaultHttpCacheTest.assertEquals((Object)this.cache.getResponse(key, req), (Object)resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotCacheableForExpiresWithWait() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        HttpResponse resp = this.createExpiresResponse(200, System.currentTimeMillis() + 1000L);
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        try {
            HttpCache httpCache = this.cache;
            synchronized (httpCache) {
                this.cache.wait(1001L);
            }
        }
        catch (InterruptedException ie) {
            DefaultHttpCacheTest.fail((String)"Failed to wait for cache");
        }
        DefaultHttpCacheTest.assertNull((Object)this.cache.getResponse(key, req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheableWithForcedMinTTL() {
        HttpRequest req = DefaultHttpCacheTest.createRequest("GET");
        req.setCacheTtl(5);
        HttpResponse resp = this.createExpiresResponse(200, System.currentTimeMillis());
        HttpCacheKey key = new HttpCacheKey(req);
        this.cache.addResponse(key, req, resp);
        try {
            HttpCache httpCache = this.cache;
            synchronized (httpCache) {
                this.cache.wait(2000L);
            }
        }
        catch (InterruptedException ie) {
            DefaultHttpCacheTest.fail((String)"Failed to wait for cache");
        }
        DefaultHttpCacheTest.assertNotNull((Object)this.cache.getResponse(key, req));
    }
}

