/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.preload.ConcurrentPreloaderService;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.Preloader;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentPreloaderServiceTest {
    private static final String PRELOAD_STRING_KEY = "key a";
    private static final String PRELOAD_NUMERIC_KEY = "key b";
    private static final String PRELOAD_MAP_KEY = "key c";
    private static final String PRELOAD_STRING_VALUE = "Some random string";
    private static final Integer PRELOAD_NUMERIC_VALUE = 5;
    private static final Map<String, String> PRELOAD_MAP_VALUE = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"blah");
    private final TestPreloader preloader = new TestPreloader();
    private final TestPreloader preloader2 = new TestPreloader();

    @Test
    public void preloadSingleService() throws PreloadException {
        this.preloader.tasks.put(PRELOAD_STRING_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_STRING_VALUE)));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService((ExecutorService)new TestExecutorService(), Arrays.asList(this.preloader));
        Assert.assertEquals((Object)PRELOAD_STRING_VALUE, (Object)service.preload(null, null).getData(PRELOAD_STRING_KEY).toJson());
    }

    @Test
    public void preloadMultipleServices() throws PreloadException {
        this.preloader.tasks.put(PRELOAD_STRING_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_STRING_VALUE)));
        this.preloader.tasks.put(PRELOAD_NUMERIC_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_NUMERIC_VALUE)));
        this.preloader2.tasks.put(PRELOAD_MAP_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_MAP_VALUE)));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService((ExecutorService)new TestExecutorService(), Arrays.asList(this.preloader, this.preloader2));
        Preloads preloads = service.preload(null, null);
        Assert.assertEquals((Object)PRELOAD_STRING_VALUE, (Object)preloads.getData(PRELOAD_STRING_KEY).toJson());
        Assert.assertEquals((Object)PRELOAD_NUMERIC_VALUE, (Object)preloads.getData(PRELOAD_NUMERIC_KEY).toJson());
        Assert.assertEquals(PRELOAD_MAP_VALUE, (Object)preloads.getData(PRELOAD_MAP_KEY).toJson());
    }

    @Test
    public void multiplePreloadsFiresJustOneInCurrentThread() throws Exception {
        this.preloader.tasks.put(PRELOAD_STRING_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_STRING_VALUE)));
        this.preloader.tasks.put(PRELOAD_NUMERIC_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_MAP_VALUE)));
        this.preloader.tasks.put(PRELOAD_MAP_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_NUMERIC_VALUE)));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService(Executors.newFixedThreadPool(5), Arrays.asList(this.preloader));
        service.preload(null, null);
        TestPreloadCallable ranInSameThread = null;
        for (Callable callable : this.preloader.tasks.values()) {
            TestPreloadCallable preloadCallable = (TestPreloadCallable)callable;
            if (ranInSameThread != null) {
                Assert.fail((String)"More than one request ran in the current thread.");
            }
            if (preloadCallable.executedThread != Thread.currentThread()) continue;
            ranInSameThread = preloadCallable;
        }
        Assert.assertNotNull((String)"No preloads executed in the current thread. ", ranInSameThread);
    }

    @Test
    public void singlePreloadExecutesInCurrentThread() throws Exception {
        this.preloader.tasks.put(PRELOAD_STRING_KEY, new TestPreloadCallable(new DataPreload(PRELOAD_STRING_VALUE)));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService(Executors.newCachedThreadPool(), Arrays.asList(this.preloader));
        service.preload(null, null);
        TestPreloadCallable callable = (TestPreloadCallable)this.preloader.tasks.get(PRELOAD_STRING_KEY);
        Assert.assertSame((String)"Single request not run in current thread", (Object)Thread.currentThread(), (Object)callable.executedThread);
    }

    @Test(expected=PreloadException.class)
    public void exceptionsArePropagated() throws PreloadException {
        this.preloader.tasks.put(PRELOAD_STRING_KEY, new TestPreloadCallable(null));
        ConcurrentPreloaderService service = new ConcurrentPreloaderService((ExecutorService)new TestExecutorService(), Arrays.asList(this.preloader));
        service.preload(null, null).getData(PRELOAD_STRING_KEY);
    }

    private static class DataPreload
    implements PreloadedData {
        private final Object data;

        public DataPreload(Object data) {
            this.data = data;
        }

        public Object toJson() {
            return this.data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestPreloadCallable
    implements Callable<PreloadedData> {
        private final PreloadedData preload;
        public Thread executedThread;

        public TestPreloadCallable(PreloadedData preload) {
            this.preload = preload;
        }

        @Override
        public PreloadedData call() throws Exception {
            this.executedThread = Thread.currentThread();
            if (this.preload == null) {
                throw new PreloadException("No preload for this test.");
            }
            return this.preload;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestPreloader
    implements Preloader {
        private final Map<String, Callable<PreloadedData>> tasks = Maps.newHashMap();

        private TestPreloader() {
        }

        public Map<String, Callable<PreloadedData>> createPreloadTasks(GadgetContext context, GadgetSpec spec) {
            return this.tasks;
        }
    }
}

