/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;

public class ContentRewriterFeatureTestCase
extends BaseRewriterTestCase {
    public void testContainerDefaultIncludeAll() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), ".*", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    public void testContainerDefaultIncludeNone() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), "", ".*", "0", this.tags);
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    public void testContainerDefaultExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), ".*", ".*", "0", this.tags);
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    public void testSpecExcludeOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("", ".*", "0", this.tags), ".*", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    public void testSpecIncludeOverridesContainerDefaultExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite(".*", "", "0", this.tags), "", ".*", "0", this.tags);
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    public void testExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "test", "0", this.tags), "", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    public void testIncludeOnlyMatch() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", this.tags), "", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://testx.test.com"));
    }

    public void testTagRewrite() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", this.tags), "", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
    }

    public void testOverrideTagRewrite() throws Exception {
        HashSet newTags = Sets.newHashSet((Object[])new String[]{"iframe"});
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", newTags), "", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
        ContentRewriterFeatureTestCase.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("link"));
    }

    public void testExpiresTimeParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "12345", this.tags), "", "", "0", this.tags);
        ContentRewriterFeatureTestCase.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        ContentRewriterFeatureTestCase.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 12345 ? 1 : 0));
    }

    public void testExpiresHTTPParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "htTp ", this.tags), "", "", "12345", this.tags);
        ContentRewriterFeatureTestCase.assertNull((Object)this.defaultRewriterFeature.getExpires());
    }

    public void testExpiresInvalidParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "junk", this.tags), "", "", "12345", this.tags);
        ContentRewriterFeatureTestCase.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        ContentRewriterFeatureTestCase.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 12345 ? 1 : 0));
    }
}

