/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlRewriter;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRewriterTest
extends BaseRewriterTestCase {
    private Uri dummyUri;
    private Map<String, HtmlTagTransformer> defaultTransformerMap;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dummyUri = Uri.parse((String)"http://www.w3c.org");
        this.defaultTransformerMap = Maps.newHashMap();
    }

    private void validateRewritten(String content, Uri base, Map<String, HtmlTagTransformer> transformerMap, String expected) {
        HtmlRewriterTest.assertEquals((String)expected, (String)HtmlRewriter.rewrite((String)content, (Uri)base, transformerMap));
    }

    private void validateRewritten(String content, String expected) {
        this.validateRewritten(content, this.dummyUri, this.defaultTransformerMap, expected);
    }

    public void testPreserveJunk() {
        String s = "<div id=notvalid name='horrorShow\" />\n</br>\n</div>";
        this.validateRewritten(s, s);
    }

    public void testPreserveScript() {
        String s = "<script src=\"http://a.b.com/1.js\">\n</script>\n<script src=\"http://a.b.com/2.js\">\n</script>";
        this.validateRewritten(s, s);
    }

    public void testPreserveCss() {
        String s = "<html><style>body { background-color:#7f7f7f }</style>";
        this.validateRewritten(s, s);
    }

    public void testBigChunk() {
        String s = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.w3.org/TR/REC-html40/loose.dtd\">\n<html><head><title>DRAFT - HTML4 Test Suite:7_5_5-BF-01</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"static.css\"></head>\n<body>\n<div class=\"navigation\">\n<h2>DRAFT - HTML4 Test Suite: Test 7_5_5-BF-01 Headings: The H1, H2,  H3, H4, H5, H6 elements</h2>\n<hr>[<a href=\"sec7_5_4-BF-02.html\">Previous</a>] [<a href=\"section8.html\">Next</a>] [<a href=\"section7.html\">Section</a>] [<a href=\"index.html\">Contents</a>] [<a href=\"http://www.w3.org/TR/html401/struct/global.html#h-7.5.5\">Specification</a>]<BR>\n\n</div>\n<object height=\"100%\" width=\"100%\" border=\"0\" type=\"text/html\" data=\"7_5_5-BF-01.html\">\n<a class=\"navigation\" href=\"7_5_5-BF-01.html\" target=\"testwindow\">Test</a></object>\n</body></html>";
        this.validateRewritten(s, s);
    }

    public void testPreserveCData() {
        String s = "<script><![CDATA[dontcare]]></script>";
        this.validateRewritten(s, s);
    }

    public void testPreserveComment() {
        String s = "<script>  <!-- something here --></script>";
        this.validateRewritten(s, s);
    }

    public void testPreserveUselessWhitespace() {
        String s = "          <script>         \n</script>";
        this.validateRewritten(s, s);
    }
}

