/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import java.util.Collections;
import javax.servlet.http.HttpServletResponse;
import junitx.framework.StringAssert;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.servlet.MakeRequestHandler;
import org.apache.shindig.gadgets.servlet.ServletTestFixture;
import org.easymock.EasyMock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;

public class MakeRequestHandlerTest
extends ServletTestFixture {
    private static final Uri REQUEST_URL = Uri.parse((String)"http://example.org/file");
    private static final String REQUEST_BODY = "I+am+the+request+body!foo=baz%20la";
    private static final String RESPONSE_BODY = "makeRequest response body";
    private static final SecurityToken DUMMY_TOKEN = new FakeGadgetToken();
    private final MakeRequestHandler handler;

    public MakeRequestHandlerTest() {
        this.handler = new MakeRequestHandler(this.fetcherFactory, this.rewriterRegistry);
    }

    private void expectGetAndReturnBody(String response) throws Exception {
        this.expectGetAndReturnBody(AuthType.NONE, response);
    }

    private void expectGetAndReturnBody(AuthType authType, String response) throws Exception {
        HttpRequest request = new HttpRequest(REQUEST_URL).setAuthType(authType);
        EasyMock.expect((Object)this.fetcherFactory.fetch(request)).andReturn((Object)new HttpResponse(response));
    }

    private void expectPostAndReturnBody(String postData, String response) throws Exception {
        this.expectPostAndReturnBody(AuthType.NONE, postData, response);
    }

    private void expectPostAndReturnBody(AuthType authType, String postData, String response) throws Exception {
        HttpRequest req = new HttpRequest(REQUEST_URL).setMethod("POST").setPostBody(REQUEST_BODY.getBytes("UTF-8")).setAuthType(authType);
        EasyMock.expect((Object)this.fetcherFactory.fetch(req)).andReturn((Object)new HttpResponse(response));
        EasyMock.expect((Object)this.request.getParameter("httpMethod")).andReturn((Object)"POST");
        EasyMock.expect((Object)this.request.getParameter("postData")).andReturn((Object)REQUEST_BODY);
    }

    private JSONObject extractJsonFromResponse() throws JSONException {
        String body = this.recorder.getResponseAsString();
        StringAssert.assertStartsWith((String)"throw 1; < don't be evil' >", (String)body);
        body = body.substring("throw 1; < don't be evil' >".length());
        return new JSONObject(body).getJSONObject(REQUEST_URL.toString());
    }

    public void setUp() {
        EasyMock.expect((Object)this.request.getMethod()).andReturn((Object)"POST").anyTimes();
        EasyMock.expect((Object)this.request.getParameter("url")).andReturn((Object)REQUEST_URL.toString()).anyTimes();
    }

    public void testGetRequest() throws Exception {
        this.expectGetAndReturnBody(RESPONSE_BODY);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)200, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testExplicitHeaders() throws Exception {
        String headerString = "X-Foo=bar&X-Bar=baz%20foo";
        HttpRequest expected = new HttpRequest(REQUEST_URL).addHeader("X-Foo", "bar").addHeader("X-Bar", "baz foo");
        EasyMock.expect((Object)this.fetcherFactory.fetch(expected)).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        EasyMock.expect((Object)this.request.getParameter("headers")).andReturn((Object)headerString);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        this.verify();
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)200, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testPostRequest() throws Exception {
        EasyMock.expect((Object)this.request.getParameter("httpMethod")).andReturn((Object)"POST");
        this.expectPostAndReturnBody(REQUEST_BODY, RESPONSE_BODY);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)200, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    @Test
    public void testFetchContentTypeFeed() throws Exception {
        String entryTitle = "Feed title";
        String entryLink = "http://example.org/entry/0/1";
        String entrySummary = "This is the summary";
        String rss = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>dummy</title><link>http://example.org/</link><item><title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "</channel></rss>";
        this.expectGetAndReturnBody(rss);
        EasyMock.expect((Object)this.request.getParameter("contentType")).andReturn((Object)"FEED");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject feed = new JSONObject(results.getString("body"));
        JSONObject entry = feed.getJSONArray("Entry").getJSONObject(0);
        MakeRequestHandlerTest.assertEquals((String)entryTitle, (String)entry.getString("Title"));
        MakeRequestHandlerTest.assertEquals((String)entryLink, (String)entry.getString("Link"));
        MakeRequestHandlerTest.assertNull((String)"getSummaries has the wrong default value (should be false).", (Object)entry.optString("Summary", null));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testFetchFeedWithParameters() throws Exception {
        String entryTitle = "Feed title";
        String entryLink = "http://example.org/entry/0/1";
        String entrySummary = "This is the summary";
        String rss = "<?xml version=\"1.0\" encoding=\"utf-8\"?><rss version=\"2.0\"><channel><title>dummy</title><link>http://example.org/</link><item><title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "<item>" + "<title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "<item>" + "<title>" + entryTitle + "</title>" + "<link>" + entryLink + "</link>" + "<description>" + entrySummary + "</description>" + "</item>" + "</channel></rss>";
        this.expectGetAndReturnBody(rss);
        EasyMock.expect((Object)this.request.getParameter("getSummaries")).andReturn((Object)"true");
        EasyMock.expect((Object)this.request.getParameter("numEntries")).andReturn((Object)"2");
        EasyMock.expect((Object)this.request.getParameter("contentType")).andReturn((Object)"FEED");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject feed = new JSONObject(results.getString("body"));
        JSONArray feeds = feed.getJSONArray("Entry");
        MakeRequestHandlerTest.assertEquals((String)"numEntries not parsed correctly.", (int)2, (int)feeds.length());
        JSONObject entry = feeds.getJSONObject(1);
        MakeRequestHandlerTest.assertEquals((String)entryTitle, (String)entry.getString("Title"));
        MakeRequestHandlerTest.assertEquals((String)entryLink, (String)entry.getString("Link"));
        MakeRequestHandlerTest.assertTrue((String)"getSummaries not parsed correctly.", (boolean)entry.has("Summary"));
        MakeRequestHandlerTest.assertEquals((String)entrySummary, (String)entry.getString("Summary"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testFetchEmptyDocument() throws Exception {
        this.expectGetAndReturnBody("");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)200, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)"", (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testSignedGetRequest() throws Exception {
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)DUMMY_TOKEN).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        HttpRequest expected = new HttpRequest(REQUEST_URL).setAuthType(AuthType.SIGNED);
        EasyMock.expect((Object)this.fetcherFactory.fetch(expected)).andReturn((Object)new HttpResponse(RESPONSE_BODY));
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testSignedPostRequest() throws Exception {
        this.expectPostAndReturnBody(AuthType.SIGNED, REQUEST_BODY, RESPONSE_BODY);
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)DUMMY_TOKEN).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertFalse((String)"A security token was returned when it was not requested.", (boolean)results.has("st"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testChangeSecurityToken() throws Exception {
        this.expectGetAndReturnBody(AuthType.SIGNED, RESPONSE_BODY);
        FakeGadgetToken authToken = new FakeGadgetToken().setUpdatedToken("updated");
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)authToken).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertEquals((String)"updated", (String)results.getString("st"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testDoOAuthRequest() throws Exception {
        this.expectGetAndReturnBody(AuthType.OAUTH, RESPONSE_BODY);
        FakeGadgetToken authToken = new FakeGadgetToken().setUpdatedToken("updated");
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn((Object)authToken).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.OAUTH.toString()).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameterMap()).andStubReturn((Object)Collections.EMPTY_MAP);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)200, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testInvalidSigningTypeTreatedAsNone() throws Exception {
        this.expectGetAndReturnBody(RESPONSE_BODY);
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)"garbage");
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)200, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertEquals((Object)RESPONSE_BODY, (Object)results.get("body"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testBadHttpResponseIsPropagated() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        EasyMock.expect((Object)this.fetcherFactory.fetch(internalRequest)).andReturn((Object)HttpResponse.error());
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((int)500, (int)results.getInt("rc"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testBadSecurityTokenThrows() throws Exception {
        EasyMock.expect((Object)this.request.getAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId())).andReturn(null).atLeastOnce();
        EasyMock.expect((Object)this.request.getParameter("authz")).andReturn((Object)AuthType.SIGNED.toString()).atLeastOnce();
        this.replay();
        try {
            this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
            MakeRequestHandlerTest.fail((String)"Should have thrown");
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testMetadataCopied() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse("foo".getBytes("UTF-8")).setMetadata("foo", RESPONSE_BODY).create();
        EasyMock.expect((Object)this.fetcherFactory.fetch(internalRequest)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        MakeRequestHandlerTest.assertEquals((String)RESPONSE_BODY, (String)results.getString("foo"));
        MakeRequestHandlerTest.assertTrue((boolean)this.rewriter.responseWasRewritten());
    }

    public void testSetCookiesReturned() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse("foo".getBytes("UTF-8")).addHeader("Set-Cookie", "foo=bar; Secure").addHeader("Set-Cookie", "name=value").create();
        EasyMock.expect((Object)this.fetcherFactory.fetch(internalRequest)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject headers = results.getJSONObject("headers");
        MakeRequestHandlerTest.assertNotNull((Object)headers);
        JSONArray cookies = headers.getJSONArray("set-cookie");
        MakeRequestHandlerTest.assertNotNull((Object)cookies);
        MakeRequestHandlerTest.assertEquals((int)2, (int)cookies.length());
        MakeRequestHandlerTest.assertEquals((Object)"foo=bar; Secure", (Object)cookies.get(0));
        MakeRequestHandlerTest.assertEquals((Object)"name=value", (Object)cookies.get(1));
    }

    public void testLocationReturned() throws Exception {
        HttpRequest internalRequest = new HttpRequest(REQUEST_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse("foo".getBytes("UTF-8")).addHeader("Location", "somewhere else").create();
        EasyMock.expect((Object)this.fetcherFactory.fetch(internalRequest)).andReturn((Object)response);
        this.replay();
        this.handler.fetch(this.request, (HttpServletResponse)this.recorder);
        JSONObject results = this.extractJsonFromResponse();
        JSONObject headers = results.getJSONObject("headers");
        MakeRequestHandlerTest.assertNotNull((Object)headers);
        JSONArray locations = headers.getJSONArray("location");
        MakeRequestHandlerTest.assertNotNull((Object)locations);
        MakeRequestHandlerTest.assertEquals((int)1, (int)locations.length());
        MakeRequestHandlerTest.assertEquals((Object)"somewhere else", (Object)locations.get(0));
    }
}

