/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.junit.Assert;
import org.junit.Test;

public class LocaleSpecTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/foo.xml");

    @Test
    public void normalLocale() throws Exception {
        String xml = "<Locale lang=\"en\" country=\"US\" language_direction=\"rtl\" messages=\"http://example.org/msgs.xml\"/>";
        LocaleSpec locale = new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"en", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"US", (Object)locale.getCountry());
        Assert.assertEquals((Object)"rtl", (Object)locale.getLanguageDirection());
        Assert.assertEquals((Object)"http://example.org/msgs.xml", (Object)locale.getMessages().toString());
    }

    @Test
    public void relativeLocale() throws Exception {
        String xml = "<Locale messages=\"/test/msgs.xml\"/>";
        LocaleSpec locale = new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"http://example.org/test/msgs.xml", (Object)locale.getMessages().toString());
    }

    @Test
    public void defaultLanguageAndCountry() throws Exception {
        String xml = "<Locale/>";
        LocaleSpec locale = new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)"all", (Object)locale.getLanguage());
        Assert.assertEquals((Object)"ALL", (Object)locale.getCountry());
    }

    @Test(expected=SpecParserException.class)
    public void invalidLanguageDirection() throws Exception {
        String xml = "<Locale language_direction=\"invalid\"/>";
        new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test(expected=SpecParserException.class)
    public void invalidMessagesUrl() throws Exception {
        String xml = "<Locale messages=\"fobad@$%!fdf\"/>";
        new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
    }

    @Test
    public void nestedMessages() throws Exception {
        String msgName = "message name";
        String msgValue = "message value";
        String xml = "<Locale><msg name=\"" + msgName + "\">" + msgValue + "</msg>" + "</Locale>";
        LocaleSpec locale = new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
        Assert.assertEquals((Object)msgValue, locale.getMessageBundle().getMessages().get(msgName));
    }

    @Test
    public void toStringIsSane() throws Exception {
        String xml = "<Locale lang='en' country='US' language_direction='rtl' messages='foo'>  <msg name='hello'>World</msg>  <msg name='foo'>Bar</msg></Locale>";
        LocaleSpec loc = new LocaleSpec(XmlUtil.parse((String)xml), SPEC_URL);
        LocaleSpec loc2 = new LocaleSpec(XmlUtil.parse((String)loc.toString()), SPEC_URL);
        Assert.assertEquals((Object)loc.getLanguage(), (Object)loc2.getLanguage());
        Assert.assertEquals((Object)loc.getCountry(), (Object)loc2.getCountry());
        Assert.assertEquals((Object)loc.getLanguageDirection(), (Object)loc2.getLanguageDirection());
        Assert.assertEquals((Object)loc.getMessages(), (Object)loc2.getMessages());
        Assert.assertEquals((Object)loc.getMessageBundle().getMessages(), (Object)loc2.getMessageBundle().getMessages());
    }
}

