/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.common.util.DateUtil;
import org.apache.shindig.gadgets.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseBuilder {
    private int httpStatusCode = 200;
    private Map<String, List<String>> headers = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private byte[] responseBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
    private Map<String, String> metadata = Maps.newHashMap();

    public HttpResponseBuilder() {
    }

    public HttpResponseBuilder(HttpResponseBuilder builder) {
        this.httpStatusCode = builder.httpStatusCode;
        this.headers.putAll(builder.headers);
        this.metadata.putAll(builder.metadata);
        this.responseBytes = builder.responseBytes;
    }

    public HttpResponseBuilder(HttpResponse response) {
        this.httpStatusCode = response.getHttpStatusCode();
        this.headers.putAll(response.getHeaders());
        this.metadata.putAll(response.getMetadata());
        this.responseBytes = response.getResponseAsBytes();
    }

    public HttpResponse create() {
        return new HttpResponse(this);
    }

    public HttpResponseBuilder setResponseString(String body) {
        this.responseBytes = CharsetUtil.getUtf8Bytes((String)body);
        return this;
    }

    public HttpResponseBuilder setResponse(byte[] responseBytes) {
        if (responseBytes == null) {
            responseBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        this.responseBytes = new byte[responseBytes.length];
        System.arraycopy(responseBytes, 0, this.responseBytes, 0, responseBytes.length);
        return this;
    }

    public HttpResponseBuilder setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        return this;
    }

    public HttpResponseBuilder addHeader(String name, String value) {
        if (name != null) {
            LinkedList values = this.headers.get(name);
            if (values == null) {
                values = Lists.newLinkedList();
                this.headers.put(name, values);
            }
            values.add(value);
        }
        return this;
    }

    public HttpResponseBuilder setHeader(String name, String value) {
        if (name != null) {
            this.headers.put(name, Lists.newLinkedList((Object[])new String[]{value}));
        }
        return this;
    }

    public HttpResponseBuilder addHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpResponseBuilder addAllHeaders(Map<String, ? extends List<String>> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public List<String> removeHeader(String name) {
        return this.headers.remove(name);
    }

    public HttpResponseBuilder setCacheTtl(int cacheTtl) {
        this.headers.remove("Pragma");
        this.headers.remove("Expires");
        this.headers.put("Cache-Control", Lists.newLinkedList((Object[])new String[]{"public,max-age=" + cacheTtl}));
        return this;
    }

    public HttpResponseBuilder setExpirationTime(int expriationTime) {
        this.headers.remove("Cache-Control");
        this.headers.remove("Pragma");
        this.headers.put("Expires", Lists.newLinkedList((Object[])new String[]{DateUtil.formatDate((long)expriationTime)}));
        return this;
    }

    public HttpResponseBuilder setStrictNoCache() {
        this.headers.put("Cache-Control", Lists.newLinkedList((Object[])new String[]{"no-cache"}));
        this.headers.put("Pragma", Lists.newLinkedList((Object[])new String[]{"no-cache"}));
        this.headers.remove("Expires");
        return this;
    }

    public HttpResponseBuilder setMetadata(String key, String value) {
        this.metadata.put(key, value);
        return this;
    }

    public HttpResponseBuilder setMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
        return this;
    }

    Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    Map<String, String> getMetadata() {
        return this.metadata;
    }

    byte[] getResponse() {
        return this.responseBytes;
    }

    int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

