/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.spec.GadgetSpec;

@Singleton
public class ContentRewriterFeatureFactory {
    private final GadgetSpecFactory specFactory;
    private final String includeUrls;
    private final String excludeUrls;
    private final String expires;
    private final Set<String> includeTags;
    private ContentRewriterFeature defaultFeature;

    @Inject
    public ContentRewriterFeatureFactory(GadgetSpecFactory specFactory, @Named(value="shindig.content-rewrite.include-urls") String includeUrls, @Named(value="shindig.content-rewrite.exclude-urls") String excludeUrls, @Named(value="shindig.content-rewrite.expires") String expires, @Named(value="shindig.content-rewrite.include-tags") String includeTags) {
        this.specFactory = specFactory;
        this.includeUrls = includeUrls;
        this.excludeUrls = excludeUrls;
        this.expires = expires;
        this.includeTags = Sets.newHashSet();
        for (String s : includeTags.split(",")) {
            if (s == null || s.trim().length() <= 0) continue;
            this.includeTags.add(s.trim().toLowerCase());
        }
        this.defaultFeature = new ContentRewriterFeature(null, includeUrls, excludeUrls, expires, this.includeTags);
    }

    public ContentRewriterFeature getDefault() {
        return this.defaultFeature;
    }

    public ContentRewriterFeature get(HttpRequest request) {
        Uri gadgetUri = request.getGadget();
        if (gadgetUri != null) {
            URI gadgetJavaUri = gadgetUri.toJavaUri();
            try {
                GadgetSpec spec = this.specFactory.getGadgetSpec(gadgetJavaUri, false);
                if (spec != null) {
                    return this.get(spec);
                }
            }
            catch (GadgetException ge) {
                return this.defaultFeature;
            }
        }
        return this.defaultFeature;
    }

    public ContentRewriterFeature get(GadgetSpec spec) {
        ContentRewriterFeature rewriterFeature = (ContentRewriterFeature)spec.getAttribute("content-rewriter");
        if (rewriterFeature != null) {
            return rewriterFeature;
        }
        rewriterFeature = new ContentRewriterFeature(spec, this.includeUrls, this.excludeUrls, this.expires, this.includeTags);
        spec.setAttribute("content-rewriter", rewriterFeature);
        return rewriterFeature;
    }
}

