/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Nullable;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.apache.shindig.gadgets.spec.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLContentRewriter
implements ContentRewriter {
    private static final int MAX_URL_LENGTH = 1500;
    public static final Set<String> TAGS = ImmutableSet.of((Object[])new String[]{"img", "embed", "link", "script", "style"});
    private static final ImmutableMap<String, ImmutableSet<String>> LINKING_TAG_ATTRS = ImmutableMap.of((Object)"img", (Object)ImmutableSet.of((Object)"src"), (Object)"embed", (Object)ImmutableSet.of((Object)"src"));
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final String proxyBaseNoGadget;
    private final String concatBaseNoGadget;

    @Inject
    public HTMLContentRewriter(ContentRewriterFeatureFactory rewriterFeatureFactory, @Named(value="shindig.content-rewrite.proxy-url") String proxyBaseNoGadget, @Named(value="shindig.content-rewrite.concat-url") String concatBaseNoGadget) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.concatBaseNoGadget = concatBaseNoGadget;
        this.proxyBaseNoGadget = proxyBaseNoGadget;
    }

    @Override
    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        if (RewriterUtils.isHtml(request, original)) {
            ContentRewriterFeature feature = this.rewriterFeatureFactory.get(request);
            return this.rewriteImpl(feature, request.getGadget(), request.getUri(), content);
        }
        return null;
    }

    @Override
    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        ContentRewriterFeature feature = this.rewriterFeatureFactory.get(gadget.getSpec());
        Uri contentBase = gadget.getSpec().getUrl();
        View view = gadget.getCurrentView();
        if (view != null && view.getHref() != null) {
            contentBase = view.getHref();
        }
        return this.rewriteImpl(feature, gadget.getSpec().getUrl(), contentBase, content);
    }

    protected RewriterResults rewriteImpl(ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase, MutableContent content) {
        if (!feature.isRewriteEnabled() || content.getDocument() == null) {
            return null;
        }
        List tagList = DomUtil.getElementsByTagNameCaseInsensitive((Document)content.getDocument(), TAGS);
        Element head = (Element)DomUtil.getFirstNamedChildNode((Node)content.getDocument().getDocumentElement(), (String)"head");
        boolean mutated = false;
        mutated = this.rewriteStyleTags(head, tagList, feature, gadgetUri, contentBase);
        mutated |= this.rewriteJsTags(tagList, feature, gadgetUri, contentBase);
        if (mutated |= this.rewriteContentReferences(tagList, feature, gadgetUri, contentBase)) {
            MutableContent.notifyEdit(content.getDocument());
        }
        return RewriterResults.cacheableIndefinitely();
    }

    protected boolean rewriteStyleTags(Element head, List<Element> elementList, ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase) {
        if (!feature.getIncludedTags().contains("style")) {
            return false;
        }
        boolean mutated = false;
        ArrayList styleTags = Lists.newArrayList((Iterable)Iterables.filter(elementList, (Predicate)new Predicate<Element>(){

            public boolean apply(@Nullable Element element) {
                return element.getNodeName().equalsIgnoreCase("style");
            }
        }));
        LinkRewriter linkRewriter = this.createLinkRewriter(gadgetUri, feature);
        for (Element styleTag : styleTags) {
            mutated |= true;
            if (styleTag.getParentNode() != head) {
                styleTag.getParentNode().removeChild(styleTag);
                head.appendChild(styleTag);
            }
            String styleText = styleTag.getTextContent();
            StringWriter sw = new StringWriter(styleText.length());
            List<String> extractedUrls = CssRewriter.rewrite(new StringReader(styleText), contentBase, linkRewriter, sw, true);
            styleText = sw.toString().trim();
            if (styleText.length() == 0 || styleText.length() < 25 && styleText.replace("<!--", "").replace("//-->", "").replace("-->", "").trim().length() == 0) {
                styleTag.getParentNode().removeChild(styleTag);
                elementList.remove(styleTag);
            } else {
                styleTag.setTextContent(styleText);
            }
            for (String extractedUrl : extractedUrls) {
                Element newLink = head.getOwnerDocument().createElement("link");
                newLink.setAttribute("rel", "stylesheet");
                newLink.setAttribute("type", "text/css");
                newLink.setAttribute("href", extractedUrl);
                head.appendChild(newLink);
                elementList.add(newLink);
            }
        }
        ArrayList linkTags = Lists.newArrayList((Iterable)Iterables.filter(elementList, (Predicate)new Predicate<Element>(){

            public boolean apply(@Nullable Element element) {
                return element.getNodeName().equalsIgnoreCase("link") && ("stylesheet".equalsIgnoreCase(element.getAttribute("rel")) || element.getAttribute("type").toLowerCase().contains("css"));
            }
        }));
        String concatBase = this.getConcatBase(gadgetUri, feature, "text/css");
        HTMLContentRewriter.concatenateTags(feature, linkTags, concatBase, contentBase, "href");
        return mutated;
    }

    protected LinkRewriter createLinkRewriter(Uri gadgetUri, ContentRewriterFeature feature) {
        return new ProxyingLinkRewriter(gadgetUri, feature, this.proxyBaseNoGadget);
    }

    protected String getConcatBase(Uri gadgetUri, ContentRewriterFeature feature, String mimeType) {
        return this.concatBaseNoGadget + "rewriteMime" + "=" + mimeType + (gadgetUri == null ? "" : "&gadget=" + Utf8UrlCoder.encode((String)gadgetUri.toString())) + "&fp=" + feature.getFingerprint() + '&';
    }

    protected boolean rewriteJsTags(List<Element> elementList, ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase) {
        if (!feature.getIncludedTags().contains("script")) {
            return false;
        }
        boolean mutated = false;
        ArrayList scriptTags = Lists.newArrayList((Iterable)Iterables.filter(elementList, (Predicate)new Predicate<Element>(){

            public boolean apply(@Nullable Element node) {
                return node.getNodeName().equalsIgnoreCase("script");
            }
        }));
        String concatBase = this.getConcatBase(gadgetUri, feature, "text/javascript");
        ArrayList concatenateable = Lists.newArrayList();
        for (int i = 0; i < scriptTags.size(); ++i) {
            Element scriptTag = (Element)scriptTags.get(i);
            Element nextSciptTag = null;
            if (i + 1 < scriptTags.size()) {
                nextSciptTag = (Element)scriptTags.get(i + 1);
            }
            if (scriptTag.hasAttribute("src") && feature.shouldRewriteURL(scriptTag.getAttribute("src"))) {
                mutated = true;
                concatenateable.add(scriptTag);
                if (nextSciptTag != null && nextSciptTag.equals(this.getNextSiblingElement(scriptTag))) continue;
                HTMLContentRewriter.concatenateTags(feature, concatenateable, concatBase, contentBase, "src");
                concatenateable.clear();
                continue;
            }
            HTMLContentRewriter.concatenateTags(feature, concatenateable, concatBase, contentBase, "src");
            concatenateable.clear();
        }
        HTMLContentRewriter.concatenateTags(feature, concatenateable, concatBase, contentBase, "src");
        return mutated;
    }

    protected boolean rewriteContentReferences(List<Element> elementList, ContentRewriterFeature feature, Uri gadgetUri, Uri contentBase) {
        boolean mutated = false;
        LinkRewriter rewriter = this.createLinkRewriter(gadgetUri, feature);
        Sets.SetView tagNames = Sets.intersection((Set)LINKING_TAG_ATTRS.keySet(), feature.getIncludedTags());
        Iterable tags = Iterables.filter(elementList, (Predicate)new Predicate<Element>((Set)tagNames){
            final /* synthetic */ Set val$tagNames;
            {
                this.val$tagNames = set;
            }

            public boolean apply(@Nullable Element node) {
                return this.val$tagNames.contains(node.getNodeName().toLowerCase());
            }
        });
        for (Element node : tags) {
            NamedNodeMap attributes = node.getAttributes();
            Set rewriteable = (Set)LINKING_TAG_ATTRS.get((Object)node.getNodeName().toLowerCase());
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if (!rewriteable.contains(attr.getNodeName().toLowerCase())) continue;
                mutated = true;
                attr.setNodeValue(rewriter.rewrite(attr.getNodeValue(), contentBase));
            }
        }
        return mutated;
    }

    private static void concatenateTags(final ContentRewriterFeature feature, List<Element> tags, String concatBase, Uri contentBase, final String attr) {
        tags = Lists.newArrayList((Iterable)Iterables.filter(tags, (Predicate)new Predicate<Element>(){

            public boolean apply(@Nullable Element element) {
                return element.hasAttribute(attr) && feature.shouldRewriteURL(element.getAttribute(attr));
            }
        }));
        LinkedHashSet nodeRefList = Sets.newLinkedHashSet();
        for (Element tag : tags) {
            try {
                nodeRefList.add(contentBase.resolve(Uri.parse((String)tag.getAttribute(attr))));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        List<Uri> concatented = HTMLContentRewriter.getConcatenatedUris(concatBase, nodeRefList);
        for (int i = 0; i < tags.size(); ++i) {
            if (i < concatented.size()) {
                ((Element)tags.get(i)).setAttribute(attr, concatented.get(i).toString());
                continue;
            }
            ((Element)tags.get(i)).getParentNode().removeChild((Node)tags.get(i));
        }
    }

    private static List<Uri> getConcatenatedUris(String concatBase, LinkedHashSet<Uri> uris) {
        LinkedList concatUris = Lists.newLinkedList();
        int paramIndex = 1;
        StringBuilder builder = null;
        int maxUriLen = 1500 + concatBase.length();
        try {
            int uriIx = 0;
            int lastUriIx = uris.size() - 1;
            for (Uri uri : uris) {
                if (paramIndex == 1) {
                    builder = new StringBuilder(concatBase);
                } else {
                    builder.append("&");
                }
                builder.append(paramIndex).append("=").append(URLEncoder.encode(uri.toString(), "UTF-8"));
                if (builder.length() > maxUriLen || uriIx == lastUriIx) {
                    concatUris.add(Uri.parse((String)builder.toString()));
                    builder = null;
                    paramIndex = 0;
                }
                ++paramIndex;
                ++uriIx;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return concatUris;
    }

    private Element getNextSiblingElement(Element elem) {
        Node n = elem;
        for (n = n.getNextSibling(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }
}

