/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.servlet.ProxyBase;

@Singleton
public class ProxyHandler
extends ProxyBase {
    private static final Logger logger = Logger.getLogger(ProxyHandler.class.getName());
    private static final Set<String> DISALLOWED_RESPONSE_HEADERS = ImmutableSet.of((Object[])new String[]{"set-cookie", "content-length", "content-encoding", "etag", "last-modified", "accept-ranges", "vary", "expires", "date", "pragma", "cache-control"});
    private final HttpFetcher fetcher;
    private final LockedDomainService lockedDomainService;
    private final ContentRewriterRegistry contentRewriterRegistry;

    @Inject
    public ProxyHandler(HttpFetcher fetcher, LockedDomainService lockedDomainService, ContentRewriterRegistry contentRewriterRegistry) {
        this.fetcher = fetcher;
        this.lockedDomainService = lockedDomainService;
        this.contentRewriterRegistry = contentRewriterRegistry;
    }

    private boolean getIgnoreCache(HttpServletRequest request) {
        String ignoreCache = request.getParameter("nocache");
        if (ignoreCache == null) {
            return false;
        }
        return !ignoreCache.equals("0");
    }

    private HttpRequest buildHttpRequest(HttpServletRequest request) throws GadgetException {
        Uri url = this.validateUrl(request.getParameter("url"));
        HttpRequest req = new HttpRequest(url);
        req.setContainer(this.getContainer(request));
        if (request.getParameter("gadget") != null) {
            req.setGadget(Uri.parse((String)request.getParameter("gadget")));
        }
        req.setRewriteMimeType(request.getParameter("rewriteMime"));
        req.setIgnoreCache(this.getIgnoreCache(request));
        if (request.getParameter("refresh") != null) {
            try {
                req.setCacheTtl(Integer.parseInt(request.getParameter("refresh")));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return req;
    }

    public void fetch(HttpServletRequest request, HttpServletResponse response) throws IOException, GadgetException {
        if (request.getHeader("If-Modified-Since") != null) {
            response.setStatus(304);
            return;
        }
        String host = request.getHeader("Host");
        if (!this.lockedDomainService.isSafeForOpenProxy(host)) {
            String msg = "Embed request for url " + this.getParameter(request, "url", "") + " made to wrong domain " + host;
            logger.info(msg);
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, msg);
        }
        HttpRequest rcr = this.buildHttpRequest(request);
        HttpResponse results = this.fetcher.fetch(rcr);
        if (this.contentRewriterRegistry != null) {
            results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results);
        }
        this.setResponseHeaders(request, response, results);
        for (Map.Entry<String, List<String>> entry : results.getHeaders().entrySet()) {
            String name = entry.getKey();
            if (DISALLOWED_RESPONSE_HEADERS.contains(name.toLowerCase())) continue;
            for (String value : entry.getValue()) {
                response.addHeader(name, value);
            }
        }
        if (rcr.getRewriteMimeType() != null) {
            response.setContentType(rcr.getRewriteMimeType());
        }
        if (results.getHttpStatusCode() != 200) {
            response.sendError(results.getHttpStatusCode());
        }
        IOUtils.copy((InputStream)results.getResponse(), (OutputStream)response.getOutputStream());
    }
}

