/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.servlet.ProxyServletRequest;

public class ProxyServlet
extends InjectedServlet {
    private static final Logger LOG = Logger.getLogger(ProxyServlet.class.getName());
    private ProxyHandler proxyHandler;

    @Inject
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.proxyHandler.fetch((HttpServletRequest)new ProxyServletRequest(request), response);
        }
        catch (GadgetException e) {
            ProxyServlet.outputError(e, response);
        }
    }

    private static void outputError(GadgetException e, HttpServletResponse resp) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Make Request failed", e);
        }
        resp.sendError(400, e.getMessage());
    }
}

