/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GadgetFeatureRegistryTest {
    private GadgetFeatureRegistry registry;
    private static final String FEATURE_NAME = "feature";
    private static final String DEP_NAME = "dependency";
    private static final String CORE_NAME = "core.feature";
    private static final String CONTENT = "var foo = 'bar'";
    private static final String CORE_CONTENT = "var core = 'dependency'";
    private static final String DEP_CONTENT = "var bar ='foo'";
    private static final String[] FEATURE_LIST = new String[]{"feature0", "feature1", "feature2", "feature3"};

    @Before
    public void setUp() throws Exception {
        this.registry = new GadgetFeatureRegistry(null, null);
        this.registry.register(this.makeFeature(CORE_NAME, CORE_CONTENT, null));
    }

    private GadgetFeature makeFeature(String name, String content, String dep) throws GadgetException {
        JsLibrary lib = JsLibrary.create((JsLibrary.Type)JsLibrary.Type.INLINE, (String)content, (String)name, null);
        LinkedList deps = Lists.newLinkedList();
        if (deps != null) {
            deps.add(dep);
        }
        return new GadgetFeature(name, Arrays.asList(lib), (Collection)deps);
    }

    @Test
    public void getLibraries() throws Exception {
        this.registry.register(this.makeFeature(DEP_NAME, DEP_CONTENT, null));
        this.registry.register(this.makeFeature(FEATURE_NAME, CONTENT, DEP_NAME));
        Collection features = this.registry.getFeatures(Arrays.asList(FEATURE_NAME));
        Assert.assertEquals((long)3L, (long)features.size());
        Iterator i = features.iterator();
        Assert.assertEquals((Object)CORE_NAME, (Object)((GadgetFeature)i.next()).getName());
        Assert.assertEquals((Object)DEP_NAME, (Object)((GadgetFeature)i.next()).getName());
        Assert.assertEquals((Object)FEATURE_NAME, (Object)((GadgetFeature)i.next()).getName());
    }

    @Test
    public void getUnknownLibraries() throws GadgetException {
        this.registry.register(this.makeFeature(FEATURE_NAME, CONTENT, DEP_NAME));
        ArrayList unsupported = Lists.newArrayList();
        this.registry.getFeatures(Arrays.asList(FEATURE_NAME, "FAKE FAKE FAKE"), (Collection)unsupported);
        Assert.assertEquals((Object)"FAKE FAKE FAKE", unsupported.get(0));
    }

    @Test
    public void getFeaturesUsesCache() throws GadgetException {
        this.registry.register(this.makeFeature(DEP_NAME, DEP_CONTENT, null));
        this.registry.register(this.makeFeature("feat0", CONTENT, DEP_NAME));
        this.registry.register(this.makeFeature("feat1", CONTENT, DEP_NAME));
        ImmutableSortedSet setKeys = ImmutableSortedSet.of((Comparable[])new String[]{"feat0", "feat1"});
        LinkedList listKeys = Lists.newLinkedList((Object[])new String[]{"feat0", "feat1"});
        Collection collectKeys = Collections.unmodifiableCollection(Lists.newArrayList((Object[])new String[]{"feat0", "feat1"}));
        Assert.assertEquals((long)0L, (long)this.registry.cache.size());
        this.registry.getFeatures(collectKeys);
        Assert.assertEquals((long)1L, (long)this.registry.cache.size());
        Collection setFeatures = this.registry.getFeatures((Collection)setKeys);
        Assert.assertEquals((long)1L, (long)this.registry.cache.size());
        Collection listFeatures = this.registry.getFeatures((Collection)listKeys);
        Assert.assertEquals((long)1L, (long)this.registry.cache.size());
        Collection collectFeatures = this.registry.getFeatures(collectKeys);
        Assert.assertEquals((long)1L, (long)this.registry.cache.size());
        Assert.assertSame((Object)listFeatures, (Object)collectFeatures);
        Assert.assertSame((Object)setFeatures, (Object)listFeatures);
    }

    @Test
    public void getAllFeatures() throws Exception {
        for (String feature : FEATURE_LIST) {
            this.registry.register(this.makeFeature(feature, CONTENT, DEP_NAME));
        }
        HashSet found = Sets.newHashSet();
        for (GadgetFeature feature : this.registry.getAllFeatures()) {
            found.add(feature.getName());
        }
        for (String feature : FEATURE_LIST) {
            Assert.assertTrue((String)(feature + " not returned."), (boolean)found.contains(feature));
        }
    }
}

