/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.FakeTimeSource;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthClientStateTest {
    private FakeTimeSource timeSource;
    private BasicBlobCrypter crypter;

    @Before
    public void setUp() throws Exception {
        this.crypter = new BasicBlobCrypter("abcdefghijklmnop".getBytes());
        this.timeSource = new FakeTimeSource();
        this.crypter.timeSource = this.timeSource;
    }

    private void assertEmpty(OAuthClientState state) {
        Assert.assertTrue((boolean)state.isEmpty());
        Assert.assertNull((Object)state.getRequestToken());
        Assert.assertNull((Object)state.getRequestTokenSecret());
        Assert.assertNull((Object)state.getAccessToken());
        Assert.assertNull((Object)state.getAccessTokenSecret());
        Assert.assertNull((Object)state.getOwner());
    }

    @Test
    public void testEncryptEmpty() throws Exception {
        OAuthClientState state = new OAuthClientState((BlobCrypter)this.crypter);
        this.assertEmpty(state);
        String encrypted = state.getEncryptedState();
        state = new OAuthClientState((BlobCrypter)this.crypter, encrypted);
        this.assertEmpty(state);
    }

    @Test
    public void testValuesSet() throws Exception {
        OAuthClientState state = new OAuthClientState((BlobCrypter)this.crypter);
        state.setAccessToken("atoken");
        state.setAccessTokenSecret("atokensecret");
        state.setOwner("owner");
        state.setRequestToken("reqtoken");
        state.setRequestTokenSecret("reqtokensecret");
        String encrypted = state.getEncryptedState();
        state = new OAuthClientState((BlobCrypter)this.crypter, encrypted);
        Assert.assertEquals((Object)"atoken", (Object)state.getAccessToken());
        Assert.assertEquals((Object)"atokensecret", (Object)state.getAccessTokenSecret());
        Assert.assertEquals((Object)"owner", (Object)state.getOwner());
        Assert.assertEquals((Object)"reqtoken", (Object)state.getRequestToken());
        Assert.assertEquals((Object)"reqtokensecret", (Object)state.getRequestTokenSecret());
    }

    @Test
    public void testNullConstructorArg() throws Exception {
        OAuthClientState state = new OAuthClientState((BlobCrypter)this.crypter, null);
        this.assertEmpty(state);
    }

    @Test
    public void testExpired() throws Exception {
        OAuthClientState state = new OAuthClientState((BlobCrypter)this.crypter);
        state.setRequestToken("reqtoken");
        String encrypted = state.getEncryptedState();
        this.timeSource.incrementSeconds(3781);
        state = new OAuthClientState((BlobCrypter)this.crypter, encrypted);
        Assert.assertNull((Object)state.getRequestToken());
    }

    @Test
    public void testNullValue() throws Exception {
        OAuthClientState state = new OAuthClientState((BlobCrypter)this.crypter);
        state.setRequestToken("reqtoken");
        state.setRequestToken(null);
        state.setOwner("owner");
        String encrypted = state.getEncryptedState();
        state = new OAuthClientState((BlobCrypter)this.crypter, encrypted);
        Assert.assertNull((Object)state.getRequestToken());
        Assert.assertEquals((Object)"owner", (Object)state.getOwner());
    }
}

