/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import junit.framework.TestCase;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoHtmlParser;
import org.apache.shindig.gadgets.rewrite.XPathWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HtmlParserTest
extends TestCase {
    private final GadgetHtmlParser nekoParser = new NekoHtmlParser(new ParseModule.DOMImplementationProvider().get());

    public void testParseSimpleString() throws Exception {
        this.parseSimpleString(this.nekoParser);
    }

    private void parseSimpleString(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("content");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((String)"content", (String)wrapper.getValue("/html/body"));
    }

    public void testParseTagWithStringContents() throws Exception {
        this.parseTagWithStringContents(this.nekoParser);
    }

    void parseTagWithStringContents(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("<span>content</span>");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((String)"content", (String)wrapper.getValue("/html/body/span"));
    }

    public void testParseTagWithAttributes() throws Exception {
        this.parseTagWithAttributes(this.nekoParser);
    }

    void parseTagWithAttributes(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("<div id=\"foo\">content</div>");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((String)"content", (String)wrapper.getValue("/html/body/div"));
        HtmlParserTest.assertEquals((String)"foo", (String)wrapper.getValue("/html/body/div/@id"));
    }

    public void testParseNestedContentWithNoCloseForBrAndHr() throws Exception {
        this.parseNestedContentWithNoCloseForBrAndHr(this.nekoParser);
    }

    void parseNestedContentWithNoCloseForBrAndHr(GadgetHtmlParser htmlParser) throws Exception {
        Document doc = htmlParser.parseDom("<div>x and y<br> and <hr>z</div>");
        XPathWrapper wrapper = new XPathWrapper(doc);
        HtmlParserTest.assertEquals((String)"x and y and z", (String)wrapper.getValue("/html/body/div"));
        HtmlParserTest.assertEquals((int)1, (int)wrapper.getNodeList("/html/body/div/br").getLength());
        HtmlParserTest.assertEquals((int)1, (int)wrapper.getNodeList("/html/body/div/hr").getLength());
    }

    private void assertNullOrEmpty(NodeList l) {
        HtmlParserTest.assertTrue((l == null || l.getLength() == 0 ? 1 : 0) != 0);
    }
}

