/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import java.util.List;
import junit.framework.TestCase;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.ParsedCssDeclaration;
import org.apache.shindig.gadgets.parse.ParsedCssRule;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;

public class CajaCssParserTest
extends TestCase {
    private final CajaCssParser csp = new CajaCssParser();

    public void testParseEveryTypeOfSelector() throws Exception {
        List rules = this.csp.parse("*, E, E F, E > F, E:first-child, E:link, E:active, E:lang(c), E + F, E[foo], E[foo=\"warning\"], DIV.blah, E#myId { color: blue; }");
        CajaCssParserTest.assertNotNull((Object)rules);
        CajaCssParserTest.assertEquals((int)1, (int)rules.size());
        ParsedCssRule rule = (ParsedCssRule)rules.get(0);
        CajaCssParserTest.assertNotNull((Object)rule.getSelectors());
        CajaCssParserTest.assertEquals((int)13, (int)rule.getSelectors().size());
        CajaCssParserTest.assertEquals((String)"*", (String)((String)rule.getSelectors().get(0)));
        CajaCssParserTest.assertEquals((String)"E", (String)((String)rule.getSelectors().get(1)));
        CajaCssParserTest.assertTrue((boolean)((String)rule.getSelectors().get(2)).matches("E\\s+F"));
        CajaCssParserTest.assertTrue((boolean)((String)rule.getSelectors().get(3)).matches("E\\s+>\\s+F"));
        CajaCssParserTest.assertEquals((String)"E:first-child", (String)((String)rule.getSelectors().get(4)));
        CajaCssParserTest.assertEquals((String)"E:link", (String)((String)rule.getSelectors().get(5)));
        CajaCssParserTest.assertEquals((String)"E:active", (String)((String)rule.getSelectors().get(6)));
        CajaCssParserTest.assertEquals((String)"E:lang(c)", (String)((String)rule.getSelectors().get(7)));
        CajaCssParserTest.assertTrue((boolean)((String)rule.getSelectors().get(8)).matches("E\\s+\\+\\s+F"));
        CajaCssParserTest.assertTrue((boolean)((String)rule.getSelectors().get(9)).matches("E\\[\\s*foo\\s*\\]"));
        CajaCssParserTest.assertTrue((boolean)((String)rule.getSelectors().get(10)).matches("E\\[\\s*foo\\s*=\\s*[\"']warning[\"']\\s*\\]"));
        CajaCssParserTest.assertEquals((String)"DIV.blah", (String)((String)rule.getSelectors().get(11)));
        CajaCssParserTest.assertEquals((String)"E#myId", (String)((String)rule.getSelectors().get(12)));
        CajaCssParserTest.assertNotNull((Object)rule.getDeclarations());
        CajaCssParserTest.assertEquals((int)1, (int)rule.getDeclarations().size());
        ParsedCssDeclaration decl = (ParsedCssDeclaration)rule.getDeclarations().get(0);
        CajaCssParserTest.assertEquals((String)"color", (String)decl.getName());
        CajaCssParserTest.assertEquals((String)"blue", (String)decl.getValue());
    }

    public void testParseWithNoDeclarations() throws Exception {
        List rules = this.csp.parse("#id { }");
        CajaCssParserTest.assertNotNull((Object)rules);
        CajaCssParserTest.assertEquals((int)1, (int)rules.size());
        ParsedCssRule rule = (ParsedCssRule)rules.get(0);
        CajaCssParserTest.assertNotNull((Object)rule);
        CajaCssParserTest.assertNotNull((Object)rule.getSelectors());
        CajaCssParserTest.assertEquals((int)1, (int)rule.getSelectors().size());
        CajaCssParserTest.assertEquals((String)"#id", (String)((String)rule.getSelectors().get(0)));
        CajaCssParserTest.assertNotNull((Object)rule.getDeclarations());
    }

    public void testParseEmptyContent() throws Exception {
        List rules = this.csp.parse("  \n\t  ");
        CajaCssParserTest.assertNotNull((Object)rules);
        CajaCssParserTest.assertEquals((int)0, (int)rules.size());
    }

    public void testParseMultipleRules() throws Exception {
        List rules = this.csp.parse("#id1 { font-size: 1; } #id2 { font-size: 2; } #id3 { font-size: 3; }");
        CajaCssParserTest.assertNotNull((Object)rules);
        CajaCssParserTest.assertEquals((int)3, (int)rules.size());
        ParsedCssRule rule = (ParsedCssRule)rules.get(0);
        CajaCssParserTest.assertNotNull((Object)rule);
        CajaCssParserTest.assertNotNull((Object)rule.getSelectors());
        CajaCssParserTest.assertEquals((String)"#id1", (String)((String)rule.getSelectors().get(0)));
        CajaCssParserTest.assertNotNull((Object)rule.getDeclarations());
        CajaCssParserTest.assertEquals((String)"font-size", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getName());
        CajaCssParserTest.assertEquals((String)"1", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getValue());
        rule = (ParsedCssRule)rules.get(1);
        CajaCssParserTest.assertNotNull((Object)rule);
        CajaCssParserTest.assertNotNull((Object)rule.getSelectors());
        CajaCssParserTest.assertEquals((String)"#id2", (String)((String)rule.getSelectors().get(0)));
        CajaCssParserTest.assertNotNull((Object)rule.getDeclarations());
        CajaCssParserTest.assertEquals((String)"font-size", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getName());
        CajaCssParserTest.assertEquals((String)"2", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getValue());
        rule = (ParsedCssRule)rules.get(2);
        CajaCssParserTest.assertNotNull((Object)rule);
        CajaCssParserTest.assertNotNull((Object)rule.getSelectors());
        CajaCssParserTest.assertEquals((String)"#id3", (String)((String)rule.getSelectors().get(0)));
        CajaCssParserTest.assertNotNull((Object)rule.getDeclarations());
        CajaCssParserTest.assertEquals((String)"font-size", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getName());
        CajaCssParserTest.assertEquals((String)"3", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getValue());
    }

    public void testParseCssNoTrailingSemicolon() throws Exception {
        List rules = this.csp.parse("#id { color:blue; font: verdana }");
        CajaCssParserTest.assertNotNull((Object)rules);
        CajaCssParserTest.assertEquals((int)1, (int)rules.size());
        ParsedCssRule rule = (ParsedCssRule)rules.get(0);
        CajaCssParserTest.assertNotNull((Object)rule);
        CajaCssParserTest.assertNotNull((Object)rule.getSelectors());
        CajaCssParserTest.assertEquals((String)"#id", (String)((String)rule.getSelectors().get(0)));
        CajaCssParserTest.assertNotNull((Object)rule.getDeclarations());
        CajaCssParserTest.assertEquals((int)2, (int)rule.getDeclarations().size());
        CajaCssParserTest.assertEquals((String)"color", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getName());
        CajaCssParserTest.assertEquals((String)"blue", (String)((ParsedCssDeclaration)rule.getDeclarations().get(0)).getValue());
        CajaCssParserTest.assertEquals((String)"font", (String)((ParsedCssDeclaration)rule.getDeclarations().get(1)).getName());
        CajaCssParserTest.assertEquals((String)"verdana", (String)((ParsedCssDeclaration)rule.getDeclarations().get(1)).getValue());
    }

    public void testParseInvalidCssNoDeclValue() throws Exception {
        try {
            String css = "#id { color: ; font-size: 10; }";
            this.csp.parse(css);
            CajaCssParserTest.fail((String)("Should have failed to parse invalid CSS: " + css));
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testParseInvalidCssNoClosingBrace() throws Exception {
        try {
            String css = "#id { color: blue; ";
            this.csp.parse(css);
            CajaCssParserTest.fail((String)("Should have failed to parse invalid CSS: " + css));
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testParseInvalidCssNoSelector() throws Exception {
        try {
            String css = "{ color: green; font: verdana; }";
            this.csp.parse(css);
            CajaCssParserTest.fail((String)("Should have failed to parse invalid CSS: " + css));
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testParseInvalidCssNoSeparator() throws Exception {
        try {
            String css = "#id { color blue; }";
            this.csp.parse(css);
            CajaCssParserTest.fail((String)("Should have failed to parse invalid CSS: " + css));
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }

    public void testParseInlineGeneralDeclarations() throws Exception {
        List decls = this.csp.parseInline("font-size: 10 em; color: green; font-color: #343434;");
        CajaCssParserTest.assertNotNull((Object)decls);
        CajaCssParserTest.assertEquals((int)3, (int)decls.size());
        CajaCssParserTest.assertEquals((String)"font-size", (String)((ParsedCssDeclaration)decls.get(0)).getName());
        CajaCssParserTest.assertEquals((String)"10 em", (String)((ParsedCssDeclaration)decls.get(0)).getValue());
        CajaCssParserTest.assertEquals((String)"color", (String)((ParsedCssDeclaration)decls.get(1)).getName());
        CajaCssParserTest.assertEquals((String)"green", (String)((ParsedCssDeclaration)decls.get(1)).getValue());
        CajaCssParserTest.assertEquals((String)"font-color", (String)((ParsedCssDeclaration)decls.get(2)).getName());
        CajaCssParserTest.assertEquals((String)"#343434", (String)((ParsedCssDeclaration)decls.get(2)).getValue());
    }

    public void testParseInlineNoDeclarations() throws Exception {
        List decls = this.csp.parseInline("");
        CajaCssParserTest.assertNotNull((Object)decls);
        CajaCssParserTest.assertEquals((int)0, (int)decls.size());
    }

    public void testParseInlineNoEndingSemicolon() throws Exception {
        List decls = this.csp.parseInline("color: green; font-size: 10");
        CajaCssParserTest.assertNotNull((Object)decls);
        CajaCssParserTest.assertEquals((int)2, (int)decls.size());
        CajaCssParserTest.assertEquals((String)"color", (String)((ParsedCssDeclaration)decls.get(0)).getName());
        CajaCssParserTest.assertEquals((String)"green", (String)((ParsedCssDeclaration)decls.get(0)).getValue());
        CajaCssParserTest.assertEquals((String)"font-size", (String)((ParsedCssDeclaration)decls.get(1)).getName());
        CajaCssParserTest.assertEquals((String)"10", (String)((ParsedCssDeclaration)decls.get(1)).getValue());
    }

    public void parseInlineNoSeparator() throws Exception {
        try {
            String iCss = "color green; font-size: 10;";
            this.csp.parseInline(iCss);
            CajaCssParserTest.fail((String)("Should have failed to parse inline CSS: " + iCss));
        }
        catch (GadgetException gadgetException) {
            // empty catch block
        }
    }
}

