/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.parse.nekohtml.NekoHtmlParser;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.w3c.dom.Document;

public class NekoParserAndSerializeTest
extends TestCase {
    private static final String EOL = System.getProperty("line.separator");
    private NekoSimplifiedHtmlParser simple = new NekoSimplifiedHtmlParser(new ParseModule.DOMImplementationProvider().get());
    private NekoHtmlParser full = new NekoHtmlParser(new ParseModule.DOMImplementationProvider().get());

    public void testDocWithDoctype() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test.html"));
        String expected = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-expected.html"));
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.simple);
    }

    public void testDocNoDoctype() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-fulldocnodoctype.html"));
        NekoParserAndSerializeTest.assertNull((Object)this.full.parseDom(content).getDoctype());
        NekoParserAndSerializeTest.assertNull((Object)this.simple.parseDom(content).getDoctype());
    }

    public void testNotADocument() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-fragment.html"));
        String expected = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-fragment-expected.html"));
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.simple);
    }

    public void testNoBody() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-headnobody.html"));
        String expected = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/parse/nekohtml/test-headnobody-expected.html"));
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.full);
        this.parseAndCompareBalanced(content, expected, (GadgetHtmlParser)this.simple);
    }

    private void parseAndCompareBalanced(String content, String expected, GadgetHtmlParser parser) throws Exception {
        Document document = parser.parseDom(content);
        expected = StringUtils.replace((String)expected, (String)EOL, (String)"\n");
        NekoParserAndSerializeTest.assertEquals((String)expected, (String)HtmlSerializer.serialize((Document)document));
    }
}

