/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.CSSContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.easymock.classextension.EasyMock;

public class CSSContentRewriterTest
extends BaseRewriterTestCase {
    private CSSContentRewriter rewriter;

    protected void setUp() throws Exception {
        super.setUp();
        ContentRewriterFeature overrideFeature = this.rewriterFeatureFactory.get(CSSContentRewriterTest.createSpecWithRewrite(".*", ".*exclude.*", "HTTP", HTMLContentRewriter.TAGS));
        ContentRewriterFeatureFactory factory = this.mockContentRewriterFeatureFactory(overrideFeature);
        this.rewriter = new CSSContentRewriter(factory, "http://www.test.com/dir/proxy?url=");
    }

    public void testCssBasic() throws Exception {
        String content = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic.css"));
        String expected = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/shindig/gadgets/rewrite/rewritebasic-expected.css"));
        HttpRequest request = new HttpRequest(Uri.parse((String)"http://www.example.org/path/rewritebasic.css"));
        request.setMethod("GET");
        request.setGadget(SPEC_URL);
        HttpResponse response = new HttpResponseBuilder().setHeader("Content-Type", "text/css").setResponseString(content).create();
        MutableContent mc = new MutableContent(null, content);
        this.rewriter.rewrite(request, response, mc);
        CSSContentRewriterTest.assertEquals((String)expected, (String)mc.getContent());
    }

    public void testNoRewriteUnknownMimeType() {
        MutableContent mc = this.mock(MutableContent.class, true);
        HttpRequest req = this.mock(HttpRequest.class);
        EasyMock.expect((Object)req.getRewriteMimeType()).andReturn((Object)"unknown");
        this.replay();
        CSSContentRewriterTest.assertNull((Object)this.rewriter.rewrite(req, this.fakeResponse, mc));
        this.verify();
    }
}

