/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;

public class ProxyingLinkRewriterTest
extends BaseRewriterTestCase {
    private String rewrite(String uri) {
        return this.defaultLinkRewriter.rewrite(uri, SPEC_URL);
    }

    public void testAbsoluteRewrite() {
        String val = "http://a.b.com";
        ProxyingLinkRewriterTest.assertEquals((String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fa.b.com&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (String)this.rewrite(val));
    }

    public void testHostRelativeRewrite() {
        String val = "/somepath/test.gif";
        ProxyingLinkRewriterTest.assertEquals((String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fsomepath%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (String)this.rewrite(val));
    }

    public void testPathRelativeRewrite() {
        String val = "test.gif";
        ProxyingLinkRewriterTest.assertEquals((String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fdir%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (String)this.rewrite(val));
    }

    public void testLeadingAndTrailingSpace() {
        String val = " test.gif ";
        ProxyingLinkRewriterTest.assertEquals((String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fdir%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334", (String)this.rewrite(val));
    }

    public void testWithRefresh() throws Exception {
        ContentRewriterFeature contentRewriterFeature = new ContentRewriterFeature(ProxyingLinkRewriterTest.createSpecWithoutRewrite(), ".*", "", "86400", (Set)Sets.newHashSet((Object[])new String[]{"embed", "img", "script", "link", "style"}));
        ProxyingLinkRewriter rewriter = new ProxyingLinkRewriter(SPEC_URL, contentRewriterFeature, "http://www.test.com/dir/proxy?url=");
        String val = " test.gif ";
        ProxyingLinkRewriterTest.assertEquals((String)"http://www.test.com/dir/proxy?url=http%3A%2F%2Fwww.example.org%2Fdir%2Ftest.gif&gadget=http%3A%2F%2Fwww.example.org%2Fdir%2Fg.xml&fp=-182800334&refresh=86400", (String)rewriter.rewrite(val, SPEC_URL));
    }

    public void testInvalidCharRewrite() {
        String val = "/images/opensocial/movie_trivia/76/${quiz.picture_url}";
        ProxyingLinkRewriterTest.assertEquals((String)val, (String)this.rewrite(val));
    }

    public void testEmpty() {
        String val = " ";
        ProxyingLinkRewriterTest.assertEquals((String)"", (String)this.rewrite(val));
    }
}

