/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.render.Renderer;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.servlet.GadgetRenderingServlet;
import org.apache.shindig.gadgets.servlet.HttpServletResponseRecorder;
import org.easymock.IMocksControl;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class GadgetRenderingServletTest {
    private static final String NON_ASCII_STRING = "Games, HQ, Mang\u00e1, Anime e tudo que um bom nerd ama";
    private final IMocksControl control = EasyMock.createNiceControl();
    private final HttpServletRequest request = (HttpServletRequest)this.control.createMock(HttpServletRequest.class);
    private final HttpServletResponse response = (HttpServletResponse)this.control.createMock(HttpServletResponse.class);
    private final Renderer renderer = (Renderer)this.control.createMock(Renderer.class);
    public final HttpServletResponseRecorder recorder = new HttpServletResponseRecorder(this.response);
    private final GadgetRenderingServlet servlet = new GadgetRenderingServlet();

    @Test
    public void dosHeaderRejected() throws Exception {
        org.easymock.EasyMock.expect((Object)this.request.getHeader("X-shindig-dos")).andReturn((Object)"foo");
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((long)403L, (long)this.recorder.getHttpStatusCode());
    }

    @Test
    public void normalResponse() throws Exception {
        this.servlet.setRenderer(this.renderer);
        org.easymock.EasyMock.expect((Object)this.renderer.render((GadgetContext)org.easymock.EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)"working"));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
        Assert.assertEquals((Object)"private,max-age=300", (Object)this.recorder.getHeader("Cache-Control"));
        Assert.assertEquals((Object)"working", (Object)this.recorder.getResponseAsString());
    }

    @Test
    public void errorsPassedThrough() throws Exception {
        this.servlet.setRenderer(this.renderer);
        org.easymock.EasyMock.expect((Object)this.renderer.render((GadgetContext)org.easymock.EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.error((String)"busted"));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((long)200L, (long)this.recorder.getHttpStatusCode());
        Assert.assertNull((String)"Cache-Control header passed where it should not be.", (Object)this.recorder.getHeader("Cache-Control"));
        Assert.assertEquals((Object)"busted", (Object)this.recorder.getResponseAsString());
    }

    @Test
    public void outputEncodingIsUtf8() throws Exception {
        this.servlet.setRenderer(this.renderer);
        org.easymock.EasyMock.expect((Object)this.renderer.render((GadgetContext)org.easymock.EasyMock.isA(GadgetContext.class))).andReturn((Object)RenderingResults.ok((String)NON_ASCII_STRING));
        this.control.replay();
        this.servlet.doGet(this.request, (HttpServletResponse)this.recorder);
        Assert.assertEquals((Object)"UTF-8", (Object)this.recorder.getCharacterEncoding());
        Assert.assertEquals((Object)"text/html", (Object)this.recorder.getContentType());
        Assert.assertEquals((Object)NON_ASCII_STRING, (Object)this.recorder.getResponseAsString());
    }
}

