/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.shindig.gadgets.GadgetBlacklist;

@Singleton
public class BasicGadgetBlacklist
implements GadgetBlacklist {
    private static final char COMMENT_MARKER = '#';
    private static final String REGEXP_PREFIX = "REGEXP";
    private final Set<String> exactMatches = Sets.newHashSet();
    private final List<Pattern> regexpMatches = Lists.newArrayList();

    public BasicGadgetBlacklist(File blacklistFile) throws IOException {
        if (blacklistFile.exists()) {
            this.parseBlacklist(blacklistFile);
        }
    }

    @Inject
    public BasicGadgetBlacklist(@Named(value="shindig.blacklist.file") String file) throws IOException {
        this(new File(file));
    }

    private void parseBlacklist(File blacklistFile) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(blacklistFile));
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            String[] parts = line.split("\\s+");
            if (parts.length == 1) {
                this.exactMatches.add(line.toLowerCase());
                continue;
            }
            if (parts.length != 2 || !parts[0].toUpperCase().equals(REGEXP_PREFIX)) continue;
            this.regexpMatches.add(Pattern.compile(parts[1], 2));
        }
    }

    public boolean isBlacklisted(URI gadgetUri) {
        String uriString = gadgetUri.toString().toLowerCase();
        if (this.exactMatches.contains(uriString)) {
            return true;
        }
        for (Pattern pattern : this.regexpMatches) {
            if (!pattern.matcher(uriString).matches()) continue;
            return true;
        }
        return false;
    }
}

