/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.ParsedFeature;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsFeatureLoader {
    public static final char FILE_SEPARATOR = ',';
    private final HttpFetcher fetcher;
    private static final Logger logger = Logger.getLogger("org.apache.shindig.gadgets");

    public void loadFeatures(String path, GadgetFeatureRegistry registry) throws GadgetException {
        LinkedList features = Lists.newLinkedList();
        try {
            for (String location : StringUtils.split((String)path, (char)',')) {
                if (location.startsWith("res://")) {
                    location = location.substring(6);
                    logger.info("Loading resources from: " + location);
                    if (location.endsWith(".txt")) {
                        ArrayList resources = Lists.newArrayList();
                        for (String resource : StringUtils.split((String)ResourceLoader.getContent((String)location), (String)"[\r\n]+")) {
                            if (StringUtils.trim((String)resource).length() <= 0 || resource.charAt(0) == '#') continue;
                            resources.add(StringUtils.trim((String)resource));
                        }
                        this.loadResources(resources, features);
                        continue;
                    }
                    this.loadResources((List<String>)ImmutableList.of((Object)location), features);
                    continue;
                }
                logger.info("Loading files from: " + location);
                File file = new File(location);
                this.loadFiles(new File[]{file}, features);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
        for (ParsedFeature feature : features) {
            GadgetFeature gadgetFeature = new GadgetFeature(feature.name, feature.libraries, feature.deps);
            registry.register(gadgetFeature);
        }
    }

    public GadgetFeature loadFeature(GadgetFeatureRegistry registry, String xml) throws GadgetException {
        ParsedFeature parsed = this.parse(xml, "", false);
        GadgetFeature feature = new GadgetFeature(parsed.name, parsed.libraries, parsed.deps);
        registry.register(feature);
        return feature;
    }

    private void loadFiles(File[] files, List<ParsedFeature> features) throws GadgetException {
        for (File file : files) {
            if (file.isDirectory()) {
                this.loadFiles(file.listFiles(), features);
                continue;
            }
            if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                if (!file.exists()) {
                    throw new GadgetException(GadgetException.Code.INVALID_PATH, "The file '" + file.getAbsolutePath() + "' doesn't exist.");
                }
                ParsedFeature feature = this.processFile(file);
                if (feature == null) continue;
                features.add(feature);
                continue;
            }
            logger.finest(file.getAbsolutePath() + " doesn't seem to be an XML file.");
        }
    }

    private void loadResources(List<String> paths, List<ParsedFeature> features) throws GadgetException {
        try {
            for (String file : paths) {
                logger.info("Processing resource: " + file);
                String content = ResourceLoader.getContent((String)file);
                String parent = file.substring(0, file.lastIndexOf(47) + 1);
                ParsedFeature feature = this.parse(content, parent, true);
                if (feature != null) {
                    features.add(feature);
                    continue;
                }
                logger.warning("Failed to parse feature: " + file);
            }
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PATH, (Throwable)e);
        }
    }

    private ParsedFeature processFile(File file) {
        logger.info("Loading file: " + file.getName());
        ParsedFeature feature = null;
        if (file.canRead()) {
            try {
                feature = this.parse(ResourceLoader.getContent((File)file), file.getParent() + '/', false);
            }
            catch (IOException e) {
                logger.warning("Error reading file: " + file.getAbsolutePath());
            }
            catch (GadgetException e) {
                logger.warning("Failed parsing file: " + file.getAbsolutePath());
            }
        } else {
            logger.warning("Unable to read file: " + file.getAbsolutePath());
        }
        return feature;
    }

    private ParsedFeature parse(String xml, String path, boolean isResource) throws GadgetException {
        Element doc;
        try {
            doc = XmlUtil.parse((String)xml);
        }
        catch (XmlException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, (Throwable)e);
        }
        ParsedFeature feature = new ParsedFeature();
        feature.basePath = path;
        feature.isResource = isResource;
        NodeList nameNode = doc.getElementsByTagName("name");
        if (nameNode.getLength() != 1) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, "No name provided");
        }
        feature.name = nameNode.item(0).getTextContent();
        NodeList gadgets = doc.getElementsByTagName("gadget");
        int j = gadgets.getLength();
        for (int i = 0; i < j; ++i) {
            this.processContext(feature, (Element)gadgets.item(i), RenderingContext.GADGET);
        }
        NodeList containers = doc.getElementsByTagName("container");
        int j2 = containers.getLength();
        for (int i = 0; i < j2; ++i) {
            this.processContext(feature, (Element)containers.item(i), RenderingContext.CONTAINER);
        }
        NodeList dependencies = doc.getElementsByTagName("dependency");
        int j3 = dependencies.getLength();
        for (int i = 0; i < j3; ++i) {
            feature.deps.add(dependencies.item(i).getTextContent());
        }
        return feature;
    }

    private void processContext(ParsedFeature feature, Element context, RenderingContext renderingContext) throws GadgetException {
        String container = XmlUtil.getAttribute((Node)context, (String)"container", (String)"default");
        NodeList libraries = context.getElementsByTagName("script");
        int j = libraries.getLength();
        for (int i = 0; i < j; ++i) {
            String content;
            JsLibrary.Type type;
            Element script = (Element)libraries.item(i);
            boolean inlineOk = XmlUtil.getBoolAttribute((Node)script, (String)"inline", (boolean)true);
            String source = XmlUtil.getAttribute((Node)script, (String)"src");
            if (source == null) {
                type = JsLibrary.Type.INLINE;
                content = script.getTextContent();
            } else {
                content = source;
                if (content.startsWith("http://")) {
                    type = JsLibrary.Type.URL;
                } else if (content.startsWith("//")) {
                    type = JsLibrary.Type.URL;
                    content = content.substring(1);
                } else if (content.startsWith("res://")) {
                    content = content.substring(6);
                    type = JsLibrary.Type.RESOURCE;
                } else if (feature.isResource) {
                    content = feature.basePath + content;
                    type = JsLibrary.Type.RESOURCE;
                } else {
                    content = feature.basePath + content;
                    type = JsLibrary.Type.FILE;
                }
            }
            JsLibrary library = JsLibrary.create(type, content, feature.name, inlineOk ? this.fetcher : null);
            for (String cont : container.split(",")) {
                feature.addLibrary(renderingContext, cont.trim(), library);
            }
        }
    }

    public JsFeatureLoader(HttpFetcher fetcher) {
        this.fetcher = fetcher;
    }
}

