/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.rewrite.lexer.HtmlTagTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRewriter {
    private HtmlRewriter() {
    }

    public static String rewrite(String content, Uri source, Map<String, HtmlTagTransformer> transformers) {
        StringWriter sw = new StringWriter(content.length() * 110 / 100);
        HtmlRewriter.rewrite(new StringReader(content), source, transformers, sw);
        return sw.toString();
    }

    public static void rewrite(Reader content, Uri source, Map<String, HtmlTagTransformer> transformers, Writer writer) {
        CharProducer producer = CharProducer.Factory.create((Reader)content, (InputSource)new InputSource(source.toJavaUri()));
        HtmlLexer lexer = new HtmlLexer(producer);
        try {
            Token lastToken = null;
            Token currentTag = null;
            HtmlTagTransformer currentTransformer = null;
            while (lexer.hasNext()) {
                boolean tagChanged = false;
                Token token = lexer.next();
                if (token.type == HtmlTokenType.IGNORABLE) continue;
                if (token.type == HtmlTokenType.TAGBEGIN) {
                    currentTag = token;
                    tagChanged = true;
                }
                if (tagChanged) {
                    if (currentTransformer == null) {
                        currentTransformer = transformers.get(currentTag.text.substring(1).toLowerCase());
                    } else if (!currentTransformer.acceptNextTag((Token<HtmlTokenType>)currentTag)) {
                        writer.write(currentTransformer.close());
                        currentTransformer = transformers.get(currentTag.text.substring(1).toLowerCase());
                    }
                }
                if (currentTransformer == null) {
                    writer.write(HtmlRewriter.producePreTokenSeparator((Token<HtmlTokenType>)token, lastToken));
                    writer.write(token.text);
                    writer.write(HtmlRewriter.producePostTokenSeparator((Token<HtmlTokenType>)token, (Token<HtmlTokenType>)lastToken));
                } else {
                    currentTransformer.accept((Token<HtmlTokenType>)token, lastToken);
                }
                if (token.type == HtmlTokenType.TAGEND) {
                    currentTag = null;
                }
                lastToken = token;
            }
            if (currentTransformer != null) {
                writer.write(currentTransformer.close());
            }
            writer.flush();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static String producePreTokenSeparator(Token<HtmlTokenType> token, Token<HtmlTokenType> lastToken) {
        if (token.type == HtmlTokenType.ATTRNAME) {
            return " ";
        }
        if (token.type == HtmlTokenType.ATTRVALUE && lastToken != null && lastToken.type == HtmlTokenType.ATTRNAME) {
            return "=";
        }
        return "";
    }

    public static String producePostTokenSeparator(Token<HtmlTokenType> token, Token<HtmlTokenType> lastToken) {
        return "";
    }
}

