/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetTestFixture;
import org.apache.shindig.gadgets.JsFeatureLoader;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.easymock.EasyMock;

public class JsFeatureLoaderTest
extends GadgetTestFixture {
    JsFeatureLoader loader;
    private static final String FEATURE_NAME = "test";
    private static final String ALT_FEATURE_NAME = "test2";
    private static final String DEF_JS_CONTENT = "var hello = 'world';";
    private static final String ALT_JS_CONTENT = "function test(){while(true);}";
    private static final String CONT_A = "test";
    private static final String CONT_B = "wuwowowaefdf";
    private static final Uri JS_URL = Uri.parse((String)"http://example.org/feature.js");

    public void setUp() throws Exception {
        super.setUp();
        this.loader = new JsFeatureLoader(this.fetcher);
    }

    private JsLibrary getJsLib(GadgetFeature feature) {
        return (JsLibrary)feature.getJsLibraries(RenderingContext.GADGET, "default").get(0);
    }

    public void testBasicLoading() throws Exception {
        String xml = "<feature>  <name>test</name>  <gadget>    <script>var hello = 'world';</script>  </gadget></feature>";
        GadgetFeature feature = this.loader.loadFeature(this.registry, xml);
        JsFeatureLoaderTest.assertEquals((String)"test", (String)feature.getName());
        JsLibrary lib = this.getJsLib(feature);
        JsFeatureLoaderTest.assertEquals((Object)JsLibrary.Type.INLINE, (Object)lib.getType());
        JsFeatureLoaderTest.assertEquals((String)DEF_JS_CONTENT, (String)lib.getContent());
    }

    public void testMultiContainers() throws Exception {
        String xml = "<feature>  <name>test</name>  <gadget container=\"test\">    <script>var hello = 'world';</script>  </gadget>  <gadget container=\"wuwowowaefdf\">    <script>function test(){while(true);}</script>  </gadget></feature>";
        GadgetFeature feature = this.loader.loadFeature(this.registry, xml);
        List libs = feature.getJsLibraries(RenderingContext.GADGET, "test");
        JsFeatureLoaderTest.assertEquals((String)DEF_JS_CONTENT, (String)((JsLibrary)libs.get(0)).getContent());
        libs = feature.getJsLibraries(RenderingContext.GADGET, CONT_B);
        JsFeatureLoaderTest.assertEquals((String)ALT_JS_CONTENT, (String)((JsLibrary)libs.get(0)).getContent());
    }

    public void testFileReferences() throws Exception {
        File temp = File.createTempFile(this.getName(), ".js-noopt");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(DEF_JS_CONTENT);
        out.close();
        String xml = "<feature>  <name>test</name>  <gadget>    <script src=\"" + temp.getPath() + "\"/>" + "  </gadget>" + "</feature>";
        GadgetFeature feature = this.loader.loadFeature(this.registry, xml);
        JsLibrary lib = this.getJsLib(feature);
        JsFeatureLoaderTest.assertEquals((String)DEF_JS_CONTENT, (String)lib.getContent());
        JsFeatureLoaderTest.assertEquals((String)"test", (String)lib.getFeature());
    }

    public void testUrlReferences() throws Exception {
        String xml = "<feature>  <name>test</name>  <gadget>    <script src=\"" + JS_URL + "\"/>" + "  </gadget>" + "</feature>";
        HttpRequest request = new HttpRequest(JS_URL);
        HttpResponse response = new HttpResponseBuilder().setResponse(ALT_JS_CONTENT.getBytes()).create();
        EasyMock.expect((Object)this.fetcher.fetch((HttpRequest)EasyMock.eq((Object)request))).andReturn((Object)response);
        this.replay();
        GadgetFeature feature = this.loader.loadFeature(this.registry, xml);
        this.verify();
        JsLibrary lib = this.getJsLib(feature);
        JsFeatureLoaderTest.assertEquals((String)ALT_JS_CONTENT, (String)lib.getContent());
        JsFeatureLoaderTest.assertEquals((String)"test", (String)lib.getFeature());
    }

    private File makeFeatureFile(String name, String content) throws Exception {
        String xml = "<feature>  <name>" + name + "</name>" + "  <gadget>" + "    <script>" + content + "</script>" + "  </gadget>" + "</feature>";
        File file = File.createTempFile(this.getName(), name + ".xml");
        file.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(xml);
        out.close();
        return file;
    }

    public void testMultiplePaths() throws Exception {
        File file1 = this.makeFeatureFile("test", DEF_JS_CONTENT);
        File file2 = this.makeFeatureFile(ALT_FEATURE_NAME, ALT_JS_CONTENT);
        this.loader.loadFeatures(file1.getAbsolutePath() + ',' + file2.getAbsolutePath(), this.registry);
        Collection features = this.registry.getAllFeatures();
        HashMap map = Maps.newHashMap();
        for (GadgetFeature feature : features) {
            map.put(feature.getName(), feature);
        }
        JsLibrary lib1 = this.getJsLib((GadgetFeature)map.get("test"));
        JsFeatureLoaderTest.assertEquals((String)DEF_JS_CONTENT, (String)lib1.getContent());
        JsLibrary lib2 = this.getJsLib((GadgetFeature)map.get(ALT_FEATURE_NAME));
        JsFeatureLoaderTest.assertEquals((String)ALT_JS_CONTENT, (String)lib2.getContent());
        file1 = this.makeFeatureFile("test,test", DEF_JS_CONTENT);
        file2 = this.makeFeatureFile("test2,test2", ALT_JS_CONTENT);
        try {
            this.loader.loadFeatures(file1.getAbsolutePath() + ',' + file2.getAbsolutePath(), this.registry);
        }
        catch (GadgetException e) {
            if (!e.getCode().equals((Object)GadgetException.Code.INVALID_PATH)) {
                throw e;
            }
            JsFeatureLoaderTest.assertTrue((String)"Invalid path catched", (boolean)true);
        }
    }
}

