/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.shindig.gadgets.parse.GadgetCssRule;
import org.apache.shindig.gadgets.parse.ParsedCssDeclaration;
import org.apache.shindig.gadgets.parse.ParsedCssRule;
import org.easymock.classextension.EasyMock;

public class GadgetCssRuleTest
extends TestCase {
    private String[] selectors = new String[]{"#id1", "  .class1 "};
    private String[][] decls = new String[][]{{"color", "blue"}, {" font-size ", "10 em"}};

    private ParsedCssDeclaration makeParsedDecl(String name, String val) {
        ParsedCssDeclaration parsedDecl = (ParsedCssDeclaration)EasyMock.createNiceMock(ParsedCssDeclaration.class);
        org.easymock.EasyMock.expect((Object)parsedDecl.getName()).andReturn((Object)name).anyTimes();
        org.easymock.EasyMock.expect((Object)parsedDecl.getValue()).andReturn((Object)val).anyTimes();
        EasyMock.replay((Object[])new Object[]{parsedDecl});
        return parsedDecl;
    }

    private ParsedCssRule makeParsedRule(String[] selectors, String[][] decls) {
        ParsedCssRule parsedMock = (ParsedCssRule)EasyMock.createNiceMock(ParsedCssRule.class);
        LinkedList selectorList = Lists.newLinkedList();
        for (String sel : selectors) {
            selectorList.add(sel);
        }
        org.easymock.EasyMock.expect((Object)parsedMock.getSelectors()).andReturn((Object)selectorList).anyTimes();
        LinkedList declList = Lists.newLinkedList();
        for (String[] decl : decls) {
            declList.add(this.makeParsedDecl(decl[0], decl[1]));
        }
        org.easymock.EasyMock.expect((Object)parsedMock.getDeclarations()).andReturn((Object)declList).anyTimes();
        EasyMock.replay((Object[])new Object[]{parsedMock});
        return parsedMock;
    }

    public void testCreatedFromParsed() {
        ParsedCssRule parsed = this.makeParsedRule(this.selectors, this.decls);
        GadgetCssRule rule = new GadgetCssRule(parsed);
        this.helperValidateCssRule(rule);
    }

    public void testCreatedManually() {
        GadgetCssRule rule = new GadgetCssRule();
        GadgetCssRuleTest.assertNotNull((Object)rule.getSelectors());
        GadgetCssRuleTest.assertEquals((int)0, (int)rule.getSelectors().size());
        GadgetCssRuleTest.assertNotNull((Object)rule.getDeclarationKeys());
        GadgetCssRuleTest.assertEquals((int)0, (int)rule.getDeclarationKeys().size());
        for (String string : this.selectors) {
            GadgetCssRuleTest.assertTrue((boolean)rule.addSelector(string, null));
        }
        for (String string : this.decls) {
            rule.setDeclaration(string[0], string[1]);
        }
        this.helperValidateCssRule(rule);
    }

    private void helperValidateCssRule(GadgetCssRule rule) {
        GadgetCssRuleTest.assertTrue((boolean)rule.hasSelector("#id1"));
        GadgetCssRuleTest.assertTrue((boolean)rule.hasSelector(".class1"));
        GadgetCssRuleTest.assertFalse((boolean)rule.hasSelector("  .class1 "));
        GadgetCssRuleTest.assertFalse((boolean)rule.hasSelector("body"));
        List seleList = rule.getSelectors();
        GadgetCssRuleTest.assertNotNull((Object)seleList);
        GadgetCssRuleTest.assertEquals((int)2, (int)seleList.size());
        GadgetCssRuleTest.assertEquals((String)"#id1", (String)((String)seleList.get(0)));
        GadgetCssRuleTest.assertEquals((String)".class1", (String)((String)seleList.get(1)));
        GadgetCssRuleTest.assertTrue((boolean)rule.removeSelector(".class1"));
        GadgetCssRuleTest.assertTrue((boolean)rule.hasSelector("#id1"));
        GadgetCssRuleTest.assertFalse((boolean)rule.hasSelector(".class1"));
        GadgetCssRuleTest.assertFalse((boolean)rule.removeSelector("nonexistent"));
        GadgetCssRuleTest.assertTrue((boolean)rule.addSelector(" .new ", null));
        GadgetCssRuleTest.assertTrue((boolean)rule.hasSelector("#id1"));
        GadgetCssRuleTest.assertTrue((boolean)rule.hasSelector(".new"));
        GadgetCssRuleTest.assertFalse((boolean)rule.hasSelector(".class1"));
        GadgetCssRuleTest.assertFalse((boolean)rule.addSelector(".new", null));
        List addSeleList = rule.getSelectors();
        GadgetCssRuleTest.assertNotNull((Object)addSeleList);
        GadgetCssRuleTest.assertEquals((int)2, (int)addSeleList.size());
        GadgetCssRuleTest.assertEquals((String)"#id1", (String)((String)addSeleList.get(0)));
        GadgetCssRuleTest.assertEquals((String)".new", (String)((String)addSeleList.get(1)));
        GadgetCssRuleTest.assertTrue((boolean)rule.addSelector(".middle", ".new"));
        List injectSeleList = rule.getSelectors();
        GadgetCssRuleTest.assertNotNull((Object)injectSeleList);
        GadgetCssRuleTest.assertEquals((int)3, (int)injectSeleList.size());
        GadgetCssRuleTest.assertEquals((String)"#id1", (String)((String)injectSeleList.get(0)));
        GadgetCssRuleTest.assertEquals((String)".middle", (String)((String)injectSeleList.get(1)));
        GadgetCssRuleTest.assertEquals((String)".new", (String)((String)injectSeleList.get(2)));
        GadgetCssRuleTest.assertFalse((boolean)rule.addSelector(".middle", ".new"));
        Set declKeys = rule.getDeclarationKeys();
        GadgetCssRuleTest.assertEquals((int)2, (int)declKeys.size());
        GadgetCssRuleTest.assertTrue((boolean)declKeys.contains("color"));
        GadgetCssRuleTest.assertEquals((String)"blue", (String)rule.getDeclarationValue("color"));
        GadgetCssRuleTest.assertTrue((boolean)declKeys.contains("font-size"));
        GadgetCssRuleTest.assertEquals((String)"10 em", (String)rule.getDeclarationValue("font-size"));
        GadgetCssRuleTest.assertTrue((boolean)rule.removeDeclaration("font-size"));
        Set removeDeclKeys = rule.getDeclarationKeys();
        GadgetCssRuleTest.assertEquals((int)1, (int)removeDeclKeys.size());
        GadgetCssRuleTest.assertTrue((boolean)removeDeclKeys.contains("color"));
        GadgetCssRuleTest.assertEquals((String)"blue", (String)rule.getDeclarationValue("color"));
        GadgetCssRuleTest.assertFalse((boolean)removeDeclKeys.contains("font-size"));
        GadgetCssRuleTest.assertFalse((boolean)rule.removeDeclaration("font-size"));
        rule.setDeclaration("color", "green");
        GadgetCssRuleTest.assertEquals((String)"green", (String)rule.getDeclarationValue("color"));
        GadgetCssRuleTest.assertEquals((int)1, (int)rule.getDeclarationKeys().size());
        rule.setDeclaration("font", "verdana");
        GadgetCssRuleTest.assertEquals((int)2, (int)rule.getDeclarationKeys().size());
        GadgetCssRuleTest.assertEquals((String)"green", (String)rule.getDeclarationValue("color"));
        GadgetCssRuleTest.assertEquals((String)"verdana", (String)rule.getDeclarationValue("font"));
    }
}

